% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures.R
\name{subset_measures}
\alias{subset_measures}
\title{Subset sentiment measures}
\usage{
subset_measures(sentomeasures, subset)
}
\arguments{
\item{sentomeasures}{a \code{sentomeasures} object created using \code{\link{sento_measures}}.}

\item{subset}{a logical expression indicating the rows to keep.}
}
\value{
A modified \code{sentomeasures} object, with only the kept rows, including updated information
and statistics, but the original sentiment scores \code{data.table} untouched.
}
\description{
Subsets rows of the sentiment measures based on its columns.
}
\examples{
data("usnews")
data("lexicons")
data("valence")

# construct a sentomeasures object to start with
corpus <- sento_corpus(corpusdf = usnews)
corpusSample <- quanteda::corpus_sample(corpus, size = 500)
l <- setup_lexicons(lexicons[c("LM_eng", "HENRY_eng")], valence[["valence_eng"]])
ctr <- ctr_agg(howTime = c("equal_weight", "linear"), by = "year", lag = 3)
sentomeasures <- sento_measures(corpusSample, l, ctr)

# different subsets
sub1 <- subset_measures(sentomeasures, HENRY_eng--economy--equal_weight >= 0.01)
sub2 <- subset_measures(sentomeasures,
   date \%in\% seq(as.Date("2000-01-01"), as.Date("2013-12-01"), by = "month"))

}
\author{
Samuel Borms
}
