% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentimentr-package.R
\docType{data}
\name{kotzias_reviews_imdb}
\alias{kotzias_reviews_imdb}
\title{Kotzias Reviews: IMBD}
\format{A data frame with 1,041 rows and 2 variables}
\usage{
data(kotzias_reviews_imdb)
}
\description{
A dataset containing a list of 4 review data sets.  Each data set contains
sentences with a positive (1) or negative review (-1) taken from reviews of
products, movies, & restaurants.  The data, compiled by Kotzias, Denil, De Freitas,
& Smyth (2015), was originally taken from amazon.com, imdb.com, & yelp.com.
Kotzias et al. (2015) provide the following description in the README:
"For each website, there exist 500 positive and
500 negative sentences. Those were selected randomly for larger datasets of
reviews. We attempted to select sentences that have a clearly positive or
negative connotation [sic], the goal was for no neutral sentences to be selected.
This data set has been manipulated from the original to be split apart by
element (sentence split).  The original 0/1 metric has also been converted
to -1/1.  Please cite Kotzias et al. (2015) if you reuse the data here.
}
\details{
\itemize{
  \item sentiment. A human scoring of the text.
  \item text. The sentences from the review.
}
}
\references{
Kotzias, D., Denil, M., De Freitas, N. & Smyth,P. (2015). From
group to individual labels using deep features. Proceedings of the 21th ACM
SIGKDD International Conference on Knowledge Discovery and Data Mining.
597-606. \url{http://mdenil.com/media/papers/2015-deep-multi-instance-learning.pdf}
}
\keyword{datasets}
