% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2_thumbnails.R
\name{s2_thumbnails}
\alias{s2_thumbnails}
\title{Create thumbnails for S2 products.}
\usage{
s2_thumbnails(
  infiles,
  prod_type = NA,
  rgb_type = "SwirNirR",
  dim = 1024,
  scaleRange = NA,
  outdir = NA,
  tmpdir = NA,
  rmtmp = TRUE,
  proc_mode = "raster",
  overwrite = FALSE
)
}
\arguments{
\item{infiles}{A vector of input filenames. Input files are paths
of products already converted from SAFE format to a
format managed by GDAL (use \link{s2_translate} to do it);
their names must be in the sen2r naming convention
(\link{safe_shortname}).}

\item{prod_type}{(optional) Output product (see \link{safe_shortname} for the
list of accepted products). If not provided, it is retrieved from the
file name.}

\item{rgb_type}{(optional) For BOA and TOA products, this value determine
the type of false colours to be used for the thumbnails:
\itemize{
\item \code{"SwirNirR"} (default) for SWIR-NIR-Red;
\item \code{"NirRG"} for NIR-Red-Green;
\item \code{"RGB"} for true colours;
}}

\item{dim}{Integer value, with the maximum greater dimension in pixels (width or
height) of the output images (default: 1024 px).
If this is lower than the corresponding dimension of the maps, maps are
rescaled before producing the thumbnails; otherwise the original dimensions
are maintained.
To keep the original size in any case, set \code{dim = Inf}.}

\item{scaleRange}{(optional) Range of valid values. If not specified
(default), it is automatically retrieved from the product type.
Default ranges for BOA and TOA products are 0 to 8000
(\code{rgb_type = "SwirNirR"}), 0 to 7500 (\code{"NirRG"}) and 0 to 2500 (\code{"RGB"}).
For spectral indices, default range is -1 to 1 for Float products, -10000
to 10000 for Int and 0 to 200 for Byte; for "Zscore" products, default
range is -3 to 3 for Float and -3000 to 3000 for Int.
It can be useful i.e. to stretch BOA "dark" products.}

\item{outdir}{(optional) Full name of the existing output directory
where the files should be created. Default is a subdirectory (named
"thumbnails") of the parent directory of each input file.}

\item{tmpdir}{(optional) Path where intermediate files (VRT) will be created.
Default is a temporary directory.
If \code{tmpdir} is a non-empty folder, a random subdirectory will be used.}

\item{rmtmp}{(optional) Logical: should temporary files be removed?
(Default: TRUE)}

\item{proc_mode}{(optional) Character: if \code{"gdal_calc"},
\code{gdal_calc} routines are used to compute indices;
if \code{"raster"} or \code{"stars"}, R functions are instead used
(using respectively \code{raster} or \code{stars} routines).
\strong{Note}: default value (\code{"raster"}) is the only fully supported mode.
\code{"gdal_calc"} can be used only if a runtime GDAL environment can be properly
configured (no assistance is provided in case of GDAL-related problems).
\code{"raster"} mode is experimental.
See \code{s2_calcindices()} for further details.}

\item{overwrite}{(optional) Logical value: should existing thumbnails be
overwritten? (default: TRUE)}
}
\value{
A vector with the names of the created images.
}
\description{
Function to create thumbnail images for Sentinel-2
products. BOA and TOA multiband images are rendered as false colour
JPEG images; SCL maps are rendered as 8-bit PNG;
other singleband images (like spectral indices) are rendered as
JPEG images with a standard colour palette.
Output images are georeferenced.
}
\note{
License: GPL 3.0
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{https://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
