% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate_resid.R
\name{rotate_resid}
\alias{rotate_resid}
\title{Rotate the residuals of selected nodes}
\usage{
rotate_resid(semPaths_plot, rotate_resid_list = NULL)
}
\arguments{
\item{semPaths_plot}{A \link[qgraph:qgraph]{qgraph::qgraph} object generated by
\link[semPlot:semPaths]{semPlot::semPaths}, or a similar qgraph object modified by other
\link{semptools} functions.}

\item{rotate_resid_list}{A named vector or a list of named list. For
a named vector, the name of an element is the node for which its
residual is to be rotated, and the value is the degree to rotate.
The 12 o'clock position is zero degree. Positive degree denotes
clockwise rotation, and negative degree denotes anticlockwise
rotation. For example, \code{c(x3 = 45, x4 = -45)} means rotating the
residual of \code{x3} 45 degrees clockwise, and rotating the residual
of \code{x4} 45 degrees anticlockwise. For a list of named lists, each
named list should have two named values: \code{node} and \code{rotate}. The
position of the residual of \code{node} will be placed at
\code{rotate}, in degree. For example, \code{list(list(node = "x3", rotate =  45), list(node = "x4", rotate = -45))} is equivalent to
\code{c(x3 = 45, x4 = -45)}.}
}
\value{
A \link[qgraph:qgraph]{qgraph::qgraph} object based on the original one, with
\code{loopRotation} attributes of selected nodes modified.
}
\description{
Rotate the residuals of selected nodes.
}
\details{
Modify a \link[qgraph:qgraph]{qgraph::qgraph} object generated by
\link[semPlot:semPaths]{semPlot::semPaths} and rotate the residuals of selected nodes.
Currently only supports "ram" and similar styles of
\link[semPlot:semPaths]{semPlot::semPaths}.
}
\examples{
mod_pa <-
 'x1 ~~ x2
  x3 ~  x1 + x2
  x4 ~  x1 + x3
 '
fit_pa <- lavaan::sem(mod_pa, pa_example)
lavaan::parameterEstimates(fit_pa)[, c("lhs", "op", "rhs", "est", "pvalue")]
m <- matrix(c("x1",   NA,   NA,
               NA, "x3", "x4",
             "x2",   NA,   NA), byrow = TRUE, 3, 3)
p_pa <- semPlot::semPaths(fit_pa, whatLabels="est",
           style = "ram",
           nCharNodes = 0, nCharEdges = 0,
           layout = m)

my_rotate_resid_vector <- c(x3 = 45, x4 = -45)

p_pa2v <- rotate_resid(p_pa, my_rotate_resid_vector)
plot(p_pa2v)

my_rotate_resid_list <- list(list(node = "x3", rotate =  45),
                         list(node = "x4", rotate = -45))

p_pa2l <- rotate_resid(p_pa, my_rotate_resid_list)
plot(p_pa2l)

}
