% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_node_attribute.R
\name{set_node_attribute}
\alias{set_node_attribute}
\title{Set the Attributes of Selected Nodes}
\usage{
set_node_attribute(semPaths_plot, values = NULL, attribute_name = NULL)
}
\arguments{
\item{semPaths_plot}{A
\link[qgraph:qgraph]{qgraph::qgraph} object generated by
\link[semPlot:semPaths]{semPlot::semPaths}, or a similar
qgraph object modified by other
\link{semptools} functions.}

\item{values}{A named vector or a
list of named list. See the Details
section on how to set this argument.}

\item{attribute_name}{The name of
the attribute to be changed.}
}
\value{
A \link[qgraph:qgraph]{qgraph::qgraph} based on
the original one, with the selected
attributes of selected nodes changed.
}
\description{
Set arbitrary attributes
of selected nodes
}
\details{
Modify a \link[qgraph:qgraph]{qgraph::qgraph}
object generated by
\link[semPlot:semPaths]{semPlot::semPaths} and change the
selected attributes of selected
nodes.

This function is designed to be a
general one that changes the
attributes named by the user. The
user needs to make sure that the
attribute actually exists, and the
values are valid for the named
attribute.
\subsection{Setting the value of \code{values}}{

This argument can be set in two ways.

For a named vector, the name of an
element should be the nodes for which
their attributes are to be changed.
The names need to the \emph{displayed}
\emph{names} if plotted, which may be
different from the names in mode.

For example, if the attributes to be
changed are the colors of selected
nodes, to change the color of \code{x}
is to be changed, the name
should be \code{"x"}. Therefore,
\code{c("y" = "red", "x" = "red")} changes
the colors of the nodes \code{y} and \code{x}
to \code{"red"} and \code{"blue"},
respectively.

For a list of named lists, each named
list should have two named values:
\code{node} and \code{new_value}. The
attribute of \code{node}
will be set to \code{new_value}.

The second approach is no longer
recommended, though kept for backward
compatibility.
}
}
\examples{
mod_pa <-
  'x1 ~~ x2
   x3 ~  x1 + x2
   x4 ~  x1 + x3
  '
fit_pa <- lavaan::sem(mod_pa, pa_example)
lavaan::parameterEstimates(fit_pa)[, c("lhs", "op", "rhs", "est", "pvalue")]
m <- matrix(c("x1",   NA,   NA,
                NA, "x3", "x4",
              "x2",   NA,   NA), byrow = TRUE, 3, 3)
p_pa <- semPlot::semPaths(fit_pa, whatLabels="est",
            style = "ram",
            nCharNodes = 0, nCharEdges = 0,
            layout = m)

my_color_vector <- c(x3 = "red", x4 = "blue")

p_pa2v <- set_node_attribute(p_pa, my_color_vector, attribute_name = "color")
plot(p_pa2v)

my_color_list <- list(list(node = "x3", new_value = "green"),
                      list(node = "x4", new_value = "red"))

p_pa2l <- set_node_attribute(p_pa, my_color_list, attribute_name = "color")
plot(p_pa2l)

}
