% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_constructs.R
\name{higher_reflective}
\alias{higher_reflective}
\title{higher_reflective}
\usage{
higher_reflective(construct_name, dimensions)
}
\arguments{
\item{construct_name}{of second-order construct}

\item{dimensions}{the first-order constructs}
}
\value{
A vector of the indicators for a higher-order-factor.
}
\description{
\code{higher_reflective} creates a higher-order reflective construct
}
\details{
This function maps first-order constructs onto second-order reflective constructs using
construct names. It is currently only suitable for CB-SEM and not PLS
}
\examples{
  mobi_mm <- constructs(
    reflective("Image",           multi_items("IMAG", 1:5)),
    reflective("Expectation",     multi_items("CUEX", 1:3)),
    higher_reflective("Quality",  c("Image", "Expectation"))
  )
}
\seealso{
See \code{\link{constructs}}, \code{\link{reflective}}
}
