% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_more_options.R
\name{show_more_options}
\alias{show_more_options}
\alias{print.show_more_options}
\title{Show More Major Options in an
Output of 'lavaan'}
\usage{
show_more_options(fit)

\method{print}{show_more_options}(x, ...)
}
\arguments{
\item{fit}{An output of
\code{\link[lavaan:lavaan]{lavaan::lavaan()}} or its wrappers
(e.g., \code{\link[lavaan:cfa]{lavaan::cfa()}} and
\code{\link[lavaan:sem]{lavaan::sem()}})}

\item{x}{The output of \code{\link[=show_more_options]{show_more_options()}}.}

\item{...}{Additional arguments. Ignored.}
}
\value{
A \code{show_more_options}-class
object with a print method that
formats the output.
}
\description{
Display the values of
more major options in a model fitted
by \code{\link[lavaan:lavaan]{lavaan::lavaan()}} or its
wrappers (e.g., \link[lavaan:sem]{lavaan::sem} or
\code{\link[lavaan:cfa]{lavaan::cfa()}}).
}
\details{
It extracts the values of
major options in the output of
\code{\link[lavaan:lavaan]{lavaan::lavaan()}} or its wrappers
(e.g., \link[lavaan:sem]{lavaan::sem} or
\code{\link[lavaan:cfa]{lavaan::cfa()}}. Most of the values
are also reported in the summary of
a \linkS4class{lavaan} object. This
function is used to show the values
in one single table for a quick
overview.

It checks the actual values, not the
call used. This is useful for
understanding how a prepackaged
estimator such as \code{ML}, \code{MLM}, and
\code{MLR} set other options. It supports
the following options:
\itemize{
\item Estimator (\code{estimator})
\item Standard error (\code{se})
\item Model chi-square test(s) (\code{test})
\item Missing data method (\code{missing})
\item Information matrix used for
computing standard errors
(\code{information})
\item Information matrix used for
computing model chi-square
(\code{information})
\item Whether the mean structure is
included.
}

It is named \code{\link[=show_more_options]{show_more_options()}} to
differentiate it from \code{show_options}
in the \code{semunpack} package, which is
intended for new users of \link{lavaan}.
The code is adapted from
\code{show_options} with more advanced
options added.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(show_more_options)}: The print method of the output of \code{\link[=show_more_options]{show_more_options()}}.

}}
\examples{
library(lavaan)

# From the help page of lavaan::cfa().

HS.model <- '
visual  =~ x1 + x2 + x3
textual =~ x4 + x5 + x6
speed   =~ x7 + x8 + x9
'
fit <- cfa(HS.model, data = HolzingerSwineford1939)

tmp <- show_more_options(fit)
tmp

fit <- cfa(HS.model, data = HolzingerSwineford1939, estimator = "MLR")
show_more_options(fit)
fit <- cfa(HS.model, data = HolzingerSwineford1939, estimator = "MLM")
show_more_options(fit)

}
\author{
Shu Fai Cheung
\url{https://orcid.org/0000-0002-9871-9448}
}
