% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store_boot_def.R
\name{store_boot_def}
\alias{store_boot_def}
\alias{get_boot_def}
\title{Store Bootstrap Estimates of User-Defined Parameters}
\usage{
store_boot_def(object, force_run = FALSE)

get_boot_def(object)
}
\arguments{
\item{object}{A \linkS4class{lavaan}
object, fitted with 'se = "boot"'.}

\item{force_run}{If \code{TRUE}, will skip
checks and run models without
checking the estimates. For internal
use. Default is \code{FALSE}.}
}
\value{
\code{\link[=store_boot_def]{store_boot_def()}} returns
the fit object set to
\code{object}, with the bootstrap values
of user-defined parameters in the
bootstrap samples, as a matrix,
stored in the
slot \code{external} of \code{object} under
the name
\code{shh_boot_def}.

\code{\link[=get_boot_def]{get_boot_def()}} returns a matrix
of the stored bootstrap estimates
of user-defined parameters
}
\description{
It receives a
\link[lavaan:lavaan-class]{lavaan::lavaan} object fitted
with bootstrapping standard errors
requested, computes the user-defined
parameters in each bootstrap samples,
and returns a \link[lavaan:lavaan-class]{lavaan::lavaan}
object
with the estimates stored.
}
\details{
\code{\link[lavaan:lavaan]{lavaan::lavaan()}} and its wrappers,
such as \code{\link[lavaan:sem]{lavaan::sem()}} and
\code{\link[lavaan:cfa]{lavaan::cfa()}}, stores the estimates
of free parameters in each bootstrap
sample if bootstrapping is requested.
However, if a model has user-defined
parameters, their values in each
bootstrap sample are not stored.
\code{\link[=store_boot_def]{store_boot_def()}} computes the
retrieves the stored bootstrap
estimates and computes the values
of user-defined parameters. The
values are then stored in the slot
\code{external} of the object,
in the element \code{shh_boot_def}.
The bootstrap estimates can then be
used by other functions for diagnostics
purposes.

\code{\link[=get_boot_def]{get_boot_def()}} extracts the
bootstrap estimates of user-defined
parameters from a \linkS4class{lavaan}
object. If none is stored, \code{NULL}
is returned.

\code{\link[=store_boot_def]{store_boot_def()}} is usually used
with diagnostic functions such
as \code{\link[=plot_boot]{plot_boot()}}.
}
\examples{

library(lavaan)
set.seed(5478374)
n <- 50
x <- runif(n) - .5
m <- .40 * x + rnorm(n, 0, sqrt(1 - .40))
y <- .30 * m + rnorm(n, 0, sqrt(1 - .30))
dat <- data.frame(x = x, y = y, m = m)
model <-
'
m ~ a*x
y ~ b*m
ab := a*b
'

# Should set bootstrap to at least 2000 in real studies
fit <- sem(model, data = dat, fixed.x = FALSE,
           se = "boot",
           bootstrap = 100)
summary(fit)

# store_boot_def() is usually used with plot_boot()
# First, store the bootstrap estimates of user-defined
# parameters
fit_with_boot_def <- store_boot_def(fit)
# Second, plot the distribution of the bootstrap estimates of
# 'ab'
plot_boot(fit_with_boot_def, "ab", standardized = FALSE)
}
\seealso{
\code{\link[=plot_boot]{plot_boot()}}
}
\author{
Shu Fai Cheung
\url{https://orcid.org/0000-0002-9871-9448}.
}
