% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_fit_by_models.R
\name{print.fit_by_models}
\alias{print.fit_by_models}
\title{Print a 'fit_by_models' Object}
\usage{
\method{print}{fit_by_models}(
  x,
  ...,
  nd = 3,
  type = c("compact"),
  remove_all_na = TRUE,
  measures_compact = c("npar", "chisq", "chisq.scaled", "df", "df.scaled", "pvalue",
    "pvalue.scaled", "chisq.scaling.factor", "cfi", "cfi.robust", "tli", "tli.robust",
    "aic", "bic", "bic2", "rmsea", "rmsea.ci.level", "rmsea.ci.lower", "rmsea.ci.upper",
    "rmsea.close.h0", "rmsea.pvalue", "rmsea.robust", "rmsea.ci.lower.robust",
    "rmsea.ci.upper.robust", "rmsea.pvalue.robust", "srmr", "srmr_nomean")
)
}
\arguments{
\item{x}{Object of the class
\code{fit_by_models}.}

\item{...}{Optional arguments to be
passed to \code{\link[=print]{print()}} methods.}

\item{nd}{The number of digits to be
printed. Default is 3. (Scientific
notation will never be used.)}

\item{type}{String. The type of the
output. Currently only supports one
type, \code{"compact"}.}

\item{remove_all_na}{Logical. Whether
rows with \code{NA} in all columns will be
removed. Default is \code{TRUE}.}

\item{measures_compact}{If output
\code{type} is \code{"compact"}, the character
vector of fit measures to be
printed. The names should be the names
of the output of \code{\link[lavaan:fitMeasures]{lavaan::fitMeasures()}},
in vector form.}
}
\value{
\code{x} is returned invisibly. Called for its side effect.
}
\description{
Print method for a
'fit_by_models' object
}
\details{
This function is intended to
print the fit measures of one or
more groups in a  simple and
compact table for quick preview.
For a well-organized
layout, call \code{\link[lavaan:fitMeasures]{lavaan::fitMeasures()}}
and set \code{output} to \code{"text"}. For
comparing the models with notations
on models with the best fit on
each measures, use
\code{\link[semTools:compareFit]{semTools::compareFit()}}.
}
\examples{

library(lavaan)
set.seed(5478374)
n <- 50
x <- runif(n) - .5
m <- .40 * x + rnorm(n, 0, sqrt(1 - .40))
y <- .30 * m + rnorm(n, 0, sqrt(1 - .30))
dat <- data.frame(x = x, y = y, m = m)
model1 <-
'
m ~ a*x
y ~ b*m
ab := a*b
'
fit1 <- sem(model1, data = dat, fixed.x = FALSE)
model2 <-
'
m ~ a*x
y ~ b*m + x
ab := a*b
'
fit2 <- sem(model2, data = dat, fixed.x = FALSE)

out <- fitMeasures_by_models(list(no_direct = fit1,
                                  direct = fit2))
out

print(out, nd = 4, measures_compact = c("chisq", "cfi", "rmsea"))

}
\seealso{
\code{\link[=fitMeasures_by_models]{fitMeasures_by_models()}}
}
\author{
Shu Fai Cheung
\url{https://orcid.org/0000-0002-9871-9448}
}
