% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{shipley.growth}
\alias{shipley.growth}
\title{Candidate Model Set from Shipley 'Growth' Model}
\format{
A list of mixed models of class \code{"lmer"} and \code{"glmer"}, fit to the
same response variable.
}
\usage{
shipley.growth
}
\description{
A set of hypothetical competing models fit to the same response
variable ('Growth') using the simulated data in Shipley (2009), for which
model estimates can be compared and/or averaged.
}
\examples{
# Specification
# shipley.growth <- list(
#   lme4::lmer(Growth ~ Date + (1 | site) + (1 | tree), data = shipley),
#   lme4::lmer(Growth ~ Date + DD + (1 | site) + (1 | tree), data = shipley),
#   lme4::lmer(Growth ~ Date + DD + lat + (1 | site) + (1 | tree),
#              data = shipley)
# )
}
\references{
Shipley, B. (2009). Confirmatory path analysis in a generalized
multilevel context. \emph{Ecology}, \emph{90}(2), 363-368. \doi{10/bqd43d}
}
\keyword{datasets}
