% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screenCapture.R, R/screenCaptureDoc.R
\name{takeScreenshot}
\alias{takeScreenshot}
\title{takeScreenshot}
\usage{
takeScreenshot(remDr, file = NULL,
  display = getOption("seleniumPipes_display_screenshot"),
  useViewer = !is.null(getOption("viewer")), returnPNG = FALSE, ...)
}
\arguments{
\item{remDr}{An object of class "rDriver". A remote driver object see \code{\link{remoteDr}}.}

\item{file}{If not null the decoded PNG is written to file using the string provided here. Defaults to NULL.}

\item{display}{logical Display the PNG or not (default is set in getOption("seleniumPipes_display_screenshot")).}

\item{useViewer}{A viewer to view the PNG. Looks for the RSudio viewer by default.}

\item{returnPNG}{logical return the decoded PNG. If false (default) remDr is returned to allw chaining.}

\item{...}{Additonal function arguments - Currently passes the \code{\link{retry}} argument.}
}
\value{
If \code{returnPNG} is FALSE the remote Driver object is returned and additonal chaining is possible. If TRUE
 then the decoded base64 image is returned see \code{\link{base64_dec}}
}
\description{
\code{takeScreenshot}
}
\examples{
\dontrun{
  remDr <- remoteDr()
  remDr \%>\% go("http://www.google.com/ncr")
  remDr \%>\% takeScreenshot

  # select the search box
  searchElem <- remDr \%>\% findElement("name", "q")
  #searchElem \%>\% takeElementScreenshot()
}

}
\seealso{
Other screenCapture functions: \code{\link{takeElementScreenshot}}
}

