% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybridalg.R
\name{hybridalg}
\alias{hybridalg}
\title{Segment data into change points using a mixed hierarchical-exact approach}
\usage{
hybridalg(data, likelihood, allow_parallel = TRUE,
  max_segments = ncol(data), threshold = 50)
}
\arguments{
\item{data}{matrix for which to find the change points}

\item{likelihood}{a function receives the segment matrix as argument
and returns a likelihood estimation. This function is used to calculate the
change points that maximize the total likelihood. Depending on the algorithm
being used, this function is likely to be executed many times, in which
case it's also likely to be the bottleneck of the function execution, so
it's advised that this function should have fast implementation.}

\item{allow_parallel}{allows parallel execution to take place using the
registered cluster. Assumes a cluster is registered with the \code{foreach}
package. Defaults to TRUE.}

\item{max_segments}{an integer that defines the maximum amount of segments to
split the data into.}

\item{threshold}{the threshold for which the exact algorithm will be used,
i.e. when the number of columns in the segment is less than or equal to the
threshold.}
}
\value{
a list of type \code{segmentr}, which has the two attributes:
\itemize{
\item \code{changepoints}: a vector with the first index of each identified change point
\item \code{segments}: a list of vectors, in which each vector corresponds to the indices
that identifies a segment.
}
}
\description{
For the larger datasets, assume the data is hierarchical, but calculate
the exact segments when they're smaller than a threshold
}
\details{
This algorithm implements an approach mixing the hierarchical and exact
algorithms. It uses the hierarchical algorithms when the size of the segment
is bigger than the threshold, and then goes on to use the exact algorithm
when the size of the segment is less than or equal to the threshold.
}
