% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loess_function.R
\name{loess_model}
\alias{loess_model}
\title{Analysis: loess regression}
\usage{
loess_model(
  trat,
  resp,
  ylab = "Germination (\%)",
  xlab = expression("Temperature ("^"o" * "C)"),
  theme = theme_classic(),
  error = "SE",
  cardinal = 0,
  legend.position = "top"
)
}
\arguments{
\item{trat}{Numerical or complex vector with treatments}

\item{resp}{Numerical vector containing the response of the experiment.}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_bw())}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{cardinal}{defines the value of y considered extreme (\emph{default} considers 0 germination)}

\item{legend.position}{legend position (\emph{default} is c(0.3,0.8))}
}
\value{
The function returns the loess regression; optimal and cardinal temperatures and graph using ggplot2.
}
\description{
Fit a polynomial surface determined by one or more numerical predictors, using local fitting.
}
\note{
if the maximum predicted value is equal to the maximum x, the curve does not have a maximum point within the studied range. If the minimum value is less than the lowest point studied, disregard the value.
}
\examples{
library(seedreg)
data("aristolochia")
attach(aristolochia)
loess_model(trat,resp)
}
\seealso{
\link{loess}
}
\author{
Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
