% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{sha3}
\alias{sha3}
\title{Cryptographic Hashing Using the SHA-3 Algorithm}
\usage{
sha3(x, bits = 256L, convert = TRUE)
}
\arguments{
\item{x}{an object.}

\item{bits}{[default 256L] output size of the returned hash - uses the
relevant SHA-3 hash function if one of 224, 256, 384 or 512, or
else the SHAKE256 extendable-output function (XOF) for arbitrary values.
The supplied value must be between 8 and 2^24, and is automatically
coerced to integer.}

\item{convert}{[default TRUE] if TRUE, the hash is converted to its hex
representation as a character string, if FALSE, output directly as a raw
vector, or if NA, a vector of (32-bit) integer values.}
}
\value{
A character string, raw or integer vector depending on 'convert'.
}
\description{
Returns a SHA-3 hash of the supplied R object. Implementated from code used
    by the the 'Mbed TLS' library under the Trusted Firmware Project.
}
\details{
For argument 'x', a character string or raw vector (with no
    attributes) is hashed 'as is'.
    
    All other objects are hashed in-place, in a 'streaming' fashion, by R
    serialization but without allocation of the serialized object. To ensure
    portability, R serialization version 3, big-endian representation is
    always used, skipping the headers (as these contain the R version number
    and native encoding information).

    The result of hashing is always a byte sequence, which is converted to a
    character string hex representation if 'convert' is TRUE, or returned as
    a raw vector if 'convert' is FALSE.
    
    To hash to integer values, set convert to NA. For a single integer value
    set 'bits' to 32. These values may be supplied as random seeds for R's
    pseudo random number generators (RNGs).
}
\examples{
# SHA3-256 hash as character string:
sha3("secret base")

# SHA3-256 hash as raw vector:
sha3("secret base", convert = FALSE)

# SHA3-224 hash as character string:
sha3("secret base", bits = 224)

# SHA3-384 hash as character string:
sha3("secret base", bits = 384)

# SHA3-512 hash as character string:
sha3("secret base", bits = 512)

# SHAKE256 hash to integer:
sha3("secret base", bits = 32L, convert = NA)

}
