% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spwt.R
\name{inverse_distance_swm}
\alias{inverse_distance_swm}
\title{construct inverse distance weight}
\usage{
inverse_distance_swm(sfj, power = 1, bandwidth = NULL)
}
\arguments{
\item{sfj}{Vector object that can be converted to \code{sf} by \code{sf::st_as_sf()}.}

\item{power}{(optional) Default is 1. Set to 2 for gravity weights.}

\item{bandwidth}{(optional) When the distance is bigger than bandwidth, the
corresponding part of the weight matrix is set to 0. Default is \code{NULL}, which
means not use the bandwidth.}
}
\value{
A inverse distance weight matrices with class of \code{matrix}.
}
\description{
Function for constructing inverse distance weight.
}
\details{
The inverse distance weight formula is
\eqn{w_{ij} = 1 / d_{ij}^\alpha}
}
\examples{
library(sf)
pts = read_sf(system.file('extdata/pts.gpkg',package = 'sdsfun'))
wt = inverse_distance_swm(pts)
wt[1:5,1:5]

}
