% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf_helpers.R
\name{sf_utm_proj_wgs84}
\alias{sf_utm_proj_wgs84}
\title{generates wgs84 utm projection epsg coding character}
\usage{
sf_utm_proj_wgs84(sfj)
}
\arguments{
\item{sfj}{An \code{sf} object or can be converted to \code{sf} by \code{sf::st_as_sf()}.}
}
\value{
A character.
}
\description{
Generates a utm projection epsg coding character corresponding to an \code{sfj} object
under the WGS84 spatial reference.
}
\details{
For more details, please refer to \url{https://zhuanlan.zhihu.com/p/670055831}.
}
\examples{
library(sf)
gzma = read_sf(system.file('extdata/gzma.gpkg',package = 'sdsfun'))
sf_utm_proj_wgs84(gzma)

}
