% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citations.R
\name{dataset_citations}
\alias{dataset_citations}
\title{Generate dataset citations}
\usage{
dataset_citations(datasets = c(), astext = TRUE)
}
\arguments{
\item{datasets}{character vector. Code of the datasets. When no datasets are 
provided (default), then all citations are returned.}

\item{astext}{logical. When \code{TRUE} (default), then citations are 
returned as text otherwise they are returned as 
"\code{\link[utils]{bibentry}}" objects.}
}
\value{
Either a character vector or a list of 
  "\code{\link[utils]{bibentry}}" objects.
}
\description{
\code{dataset_citations} returns dataset citations as text or as 
"\code{\link[utils]{bibentry}}" objects.
}
\details{
Note that in order to generate a full list of citations it is
  preferable to run the \code{\link{layer_citations}} function.
}
\examples{
# print the Bio-ORACLE citation
print(dataset_citations("Bio-ORACLE"))

# print all citations as Bibtex
print(lapply(dataset_citations(astext = FALSE), toBibtex))
}
\seealso{
\code{\link{layer_citations}}, \code{\link[utils]{bibentry}}, 
  \code{\link{list_datasets}}
}
