% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeProblem.R
\name{makeProblem}
\alias{makeProblem}
\title{create \code{\link{sdcProblem-class}}-objects}
\usage{
makeProblem(data, dimList, dimVarInd = NULL, freqVarInd = NULL,
  numVarInd = NULL, weightInd = NULL, sampWeightInd = NULL)
}
\arguments{
\item{data}{a data frame featuring at least one column for each desired
dimensional variable. Optionally the input data can feature variables
that contain information on cell counts, weights that should be used during
the cut and branch algorithm, additional numeric variables or variables that
hold information on sampling weights.}

\item{dimList}{a named list where the names refer to variable names in 
input \code{data}. Each list element can be one of: 
\itemize{
\item{\code{tree}: }{generated with \code{hier_*()} functions from the 
sdcHierarchies package}
\item{\code{data.frame}: }{a two column \code{data.frame} containing 
the complete level hierarchy of a dimensional variable using a 
top-to-bottom approach. The format of the \code{data.frame} is as follows:
\itemize{
\item first column: a character vector specifying levels with each vector 
element being a string only containing of '@'s from length 1 to n. 
If a vector element consists of \code{i}-chars, the corresponding code 
is of level \code{i}. The code '@' (one character) equals the grand 
total (level=1), the code `@@` (two characters) is of level 2 (directly
below the overall total).
\item second column: a character vector specifying level codes
}}
\item{\code{path}: }{absolute or relative path to a \code{.csv} file that
contains two columns seperated by semicolons (;) having the same structure 
as the \code{"@;levelname"}-structure described above}
}}

\item{dimVarInd}{numeric vector (or NULL) defining the column-indices of 
dimensional variables (defining the table) within argument \code{data}. 
If \code{NULL}, the names of argument \code{dimList} are used to calculate 
the indices of the dimensional variables within \code{data} internally.}

\item{freqVarInd}{numeric vector (or NULL) defining the column-indices 
of a variable holding counts within argument \code{data}}

\item{numVarInd}{numeric vector (or NULL) defining the column-indices 
of additional numeric variables available in argument \code{data}}

\item{weightInd}{numeric vector of length 1 (or NULL) defining the 
column-index of a variable holding weights that should be used during 
as objective coefficients during the cut and branch algorithm to 
protect primary sensitive cells within argument \code{data}}

\item{sampWeightInd}{numeric vector of length 1 (or NULL) defining 
the column-index of a variable holding sampling weights within 
argument \code{data}}
}
\value{
a \code{\link{sdcProblem-class}}-object
}
\description{
Function \code{\link{makeProblem}} is used to create
\code{\link{sdcProblem-class}}-objects.
}
\examples{
# loading micro data
data("microData1", package="sdcTable")
microData <- microData1; rm(microData1)
# having a look at the data structure
str(microData)

# we can observe that we have a micro data set consisting
# of two spanning variables ('region' and 'gender') and one
# numeric variable ('val')

# specify structure of hierarchical variable 'region'
# levels 'A' to 'D' sum up to a Total
dim.region <- data.frame(
 levels=c('@','@@','@@','@@','@@'),
 codes=c('Total', 'A','B','C','D'),
 stringsAsFactors=FALSE)

# specify structure of hierarchical variable 'gender'
# using create_node() and add_nodes() (see ?manage_hierarchies)
dim.gender <- hier_create(root = "Total", nodes = c("male", "female"))
hier_display(dim.gender)

# create a named list with each element being a data-frame
# containing information on one dimensional variable and
# the names referring to variables in the input data
dimList <- list(region=dim.region, gender=dim.gender)

# third column containts a numeric variable
numVarInd <- 3

# no variables holding counts, numeric values, weights or sampling
# weights are available in the input data
freqVarInd <- weightInd <- sampWeightInd <- NULL

# creating an object of class \\code{\\link{sdcProblem-class}}
problem <- makeProblem(
 data=microData,
 dimList=dimList,
 freqVarInd=freqVarInd,
 numVarInd=numVarInd,
 weightInd=weightInd,
 sampWeightInd=sampWeightInd)

# what do we have?
print(class(problem))

# have a look at the data
sdcProb2df(problem, addDups=TRUE,
  addNumVars=TRUE, dimCodes="original")
}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}
