% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_simpleTriplet.r, R/methods_class_simpleTriplet.r
\docType{methods}
\name{calc.simpleTriplet}
\alias{calc.simpleTriplet}
\alias{calc.simpleTriplet,simpleTriplet,character,list-method}
\title{modify \code{simpleTriplet}-objects depending on argument \code{type}}
\usage{
calc.simpleTriplet(object, type, input)

\S4method{calc.simpleTriplet}{simpleTriplet,character,list}(object, type, input)
}
\arguments{
\item{object}{an object of class \code{simpleTriplet}}

\item{type}{a character vector of length 1 defining what to calculate|return|modify. Allowed types are:}
\itemize{
\item removeRow: remove a row with given index from \code{object}
\item removeCol: remove a column with given index from \code{object}
\item addRow: add a row to \code{object}
\item addCol: add a column to \code{object}
\item modifyRow: change specified row of \code{object}
\item modifyCol: change specified column of \code{object}
\item modifyCell: change specified cell of \code{object}
\item bind: bind two objects of class \code{simpleTriplet} together}

\item{input}{a list depending on argument \code{type}.}

\itemize{
\item type==removeRow: input is a list of length 1
\itemize{
\item first element: numeric vector of length 1 defining the index of the row that should be removed }
\item type==removeCol: input is a list of length 1
\itemize{
\item first element: numeric vector of length 1 defining the index of the column that should be removed }
\item type==addRow: input is a list of length 2
\itemize{
\item first element: numeric vector of column-indices
\item second element: numeric vector defining the cell-values of the row that will be added }
\item type==addCol: input is a list of length 2
\itemize{
\item first element: numeric vector of row-indices
\item second element: numeric vector defining the cell-values of the column that will be added }
\item type==modifyRow: input is a list of length 3
\itemize{
\item first element: numeric vector of length 1 specifying the the row-index of the row that will be modified
\item second element: numeric vector specifying the column-indices that should be modified
\item third element: numeric vector defining values that should be set in the given row }
\item type==modifyCol: input is a list of length 3
\itemize{
\item first element: numeric vector specifying the row-indices that should be modified
\item second element: numeric vector of length 1 specifying the the column-index of the column that will be modified
\item third element: numeric vector defining values that should be set in the given column }
\item type==modifyCell: input is a list of length 3
\itemize{
\item first element: numeric vector of length 1 defining the column-index
\item second element: numeric vector of length 1 defining the row-index
\item third element: numeric vector of length 1 holding the value that should be set in the given cell }
\item type==bind: input is a list of length 2
\itemize{
\item first element: an object of class \code{simpleTriplet}
\item second argument: is a logical vector of length 1 being TRUE if a 'rbind' or 'FALSE' if a 'cbind' should be done }}
}
\value{
an object of class \code{simpleTriplet}
}
\description{
modify \code{simpleTriplet}-objects depending on argument \code{type}
}
\note{
internal function
}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}

