\docType{class}
\name{cutList-class}
\alias{cutList-class}
\title{S4 class describing a cutList-object}
\description{
An object of class \code{cutList} holds constraints that
can be extracted and used as for objects of class
\code{\link{linProb-class}}. An object of class
\code{cutList} consists of a constraint matrix (slot
\code{con}), a vector of directions (slot \code{direction})
and a vector specifying the right hand sides of the
constraints (slot \code{rhs}).
}
\details{
\describe{ \item{slot \code{con}:}{an object of class
\code{\link{simpleTriplet-class}} specifying the constraint
matrix of the problem} \item{slot \code{direction}:}{a
character vector holding the directions of the constraints,
allowed values are: \itemize{ \item \code{==}: equal \item
\code{<}: less \item \code{>}: greater \item \code{<=}:
less or equal \item \code{>=}: greater or equal} }
\item{slot \code{rhs}:}{numeric vector holding right hand
side values of the constraints} }
}
\note{
objects of class \code{cutList} are dynamically generated
(and removed) during the cut and branch algorithm when
solving the secondary cell suppression problem
}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}

