% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdc_raster.R
\name{sdc_raster}
\alias{sdc_raster}
\title{Create a raster map with privacy awareness}
\usage{
sdc_raster(
  x,
  variable,
  r = 200,
  max_risk = 0.95,
  min_count = 10,
  risk_type = c("external", "internal", "discrete"),
  ...,
  field = variable
)
}
\arguments{
\item{x}{\link[sp:SpatialPoints]{sp::SpatialPointsDataFrame}, \link[sf:sf]{sf::sf} or a two column matrix or \link{data.frame}
that is used to create a raster map.}

\item{variable}{name of data column or \code{numeric} with same length as \code{x}
to be used for the data in the raster map.}

\item{r}{either a desired resolution or a pre-existing \link{raster} object.
In the first case, the crs of \code{x} (if present) will be used, in the latter
the properties of the \code{r} will be kept.}

\item{max_risk}{\code{numeric}, the maximum_risk score (\code{\link{disclosure_risk}})
before a cell in the map is considered sensitive.}

\item{min_count}{\code{numeric}, a raster cell with less then \code{min_count}
observations is considered sensitived.}

\item{risk_type}{passed on to \code{\link[=disclosure_risk]{disclosure_risk()}}.}

\item{...}{passed through to \code{\link[raster:rasterize]{raster::rasterize()}}}

\item{field}{synonym for \code{variable}. If both supplied, \code{field} has precedence.}
}
\value{
object of \code{class} "sdc_raster":
\itemize{
\item \verb{$value}: \code{\link[raster:brick]{raster::brick()}} object with different layers e.g. \code{count}, \code{sum}, \code{mean}, \code{scale}.
\item \verb{$max_risk}: see above.
\item \verb{$min_count}: see above.
of protection operation \code{\link[=protect_smooth]{protect_smooth()}} or \code{\link[=protect_quadtree]{protect_quadtree()}}.
\item \verb{$type}: data type of \code{variable}, either \code{numeric} or \code{logical}
\item \verb{$risk_type}, "external", "internal" or "discrete" (see \code{\link[=disclosure_risk]{disclosure_risk()}})
}
}
\description{
\code{sdc_raster} creates multiple \code{\link[raster:raster]{raster::raster}} objects
("count", "mean", "sum") from supplied point data \code{x} and calculates
the sensitivity to privacy disclosure for each raster location.
}
\details{
A \code{sdc_raster} object is the vehicle that does the book keeping for calculating
sensitivity. Protection methods work upon a \code{sdc_raster} and return a new
\code{sdc_raster} in which the sensitivity is reduced.
The sensitivity of the map can be assessed with \link{sensitivity_score},
\code{\link[=plot.sdc_raster]{plot.sdc_raster()}}, \code{\link[=plot_sensitive]{plot_sensitive()}} or \code{print}.
Reducing the sensitivity can be done with \code{\link[=protect_smooth]{protect_smooth()}},
\code{\link[=protect_quadtree]{protect_quadtree()}} and \code{\link[=remove_sensitive]{remove_sensitive()}}. Raster maps for \code{mean},
\code{sum} and \code{count} data can be extracted from the \verb{$value} (\code{\link[=brick]{brick()}}).
}
\examples{
\donttest{
library(raster)
prod <- sdc_raster(enterprises, field = "production", r = 500)
print(prod)

prod <- sdc_raster(enterprises, field = "production", r = 1e3)
print(prod)

# get raster with the average production per cell averaged over the enterprises
prod_mean <- mean(prod)
summary(prod_mean)

# get raster with the total production per cell
prod_total <- sum(prod)
summary(prod_total)
}
}
\seealso{
Other sensitive: 
\code{\link{disclosure_risk}()},
\code{\link{is_sensitive_at}()},
\code{\link{is_sensitive}()},
\code{\link{plot_sensitive}()},
\code{\link{remove_sensitive}()},
\code{\link{sensitivity_score}()}
}
\concept{sensitive}
