% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dUtility.R
\docType{methods}
\name{dUtility}
\alias{dUtility}
\title{data utility}
\usage{
dUtility(obj, ...)
}
\arguments{
\item{obj}{original data or object of class \code{\link{sdcMicroObj-class}}}

\item{...}{see arguments below
\itemize{
\item{xm: }{perturbed data}
\item{method: }{method IL1, IL1s or eigen. More methods are implemented in
summary.micro()}}}
}
\value{
data utility or modified entry for data utility the \code{\link{sdcMicroObj-class}}.
}
\description{
IL1s data utility.
}
\details{
The standardised distances of the perturbed data values to the original ones
are measured.  Measure IL1 measures the distances between the original
values and the perturbed ones, scaled by the standard deviation.  Method
\sQuote{eigen} and \sQuote{robeigen} compares the eigenvalues and robust
eigenvalues form the original data and the perturbed data.
}
\examples{
data(free1)
free1 <- as.data.frame(free1)
m1 <- microaggregation(free1[, 31:34], method="onedims", aggr=3)
m2 <- microaggregation(free1[, 31:34], method="pca", aggr=3)
dRisk(obj=free1[, 31:34], xm=m1$mx)
dRisk(obj=free1[, 31:34], xm=m2$mx)
dUtility(obj=free1[, 31:34], xm=m1$mx)
dUtility(obj=free1[, 31:34], xm=m2$mx)
data(Tarragona)
x <- Tarragona[, 5:7]
y <- addNoise(x)$xm
dRiskRMD(x, xm=y)
dRisk(x, xm=y)
dUtility(x, xm = y, method = "IL1")
dUtility(x, xm = y, method = "IL1s")
dUtility(x, xm = y, method = "eigen")
dUtility(x, xm = y, method = "robeigen")

## for objects of class sdcMicro:
data(testdata2)
sdc <- createSdcObj(testdata2,
  keyVars=c('urbrur','roof','walls','water','electcon','relat','sex'),
  numVars=c('expend','income','savings'), w='sampling_weight')
## this is already made internally:
## sdc <- dUtility(sdc)
## and already stored in sdc

}
\references{
for IL1 and IL1s: see
\url{http://vneumann.etse.urv.es/webCrises/publications/isijcr/lncs3050Outlier.pdf},

Templ, M. and Meindl, B., \emph{Robust Statistics Meets SDC: New Disclosure
Risk Measures for Continuous Microdata Masking}, Lecture Notes in Computer
Science, Privacy in Statistical Databases, vol. 5262, pp. 113-126, 2008.
}
\seealso{
\code{\link{dRisk}}, \code{\link{dRiskRMD}}
}
\author{
Matthias Templ
}
\keyword{manip}
