% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_sdPrior.r
\name{dapprox_unif}
\alias{dapprox_unif}
\title{Compute Density Function of Approximated (Differentiably) Uniform Distribution.}
\usage{
dapprox_unif(x, scale, tildec = 13.86294)
}
\arguments{
\item{x}{denotes the argument of the density function.}

\item{scale}{the scale parameter originally defining the upper bound of the uniform distribution.}

\item{tildec}{denotes the ratio between scale parameter \eqn{\theta} and \eqn{s}. The latter is responsible for the closeness of
the approximation to the uniform distribution. See also below for further details and the default value.}
}
\value{
the density.
}
\description{
Compute Density Function of Approximated (Differentiably) Uniform Distribution.
}
\details{
The density of the uniform distribution for \eqn{\tau} is approximated by
         \deqn{p(\tau)=(1/(1+exp(\tau\tilde{c}/\theta-\tilde{c})))/(\theta(1+log(1+exp(-\tilde{c}))))}.
		This results in \deqn{p(\tau^2)=0.5*(\tau^2)^(-1/2)(1/(1+exp((\tau^2)^(1/2)\tilde{c}/\theta-\tilde{c})))/(\theta(1+log(1+exp(-\tilde{c}))))} for \eqn{tau^2}.
			\eqn{\tilde{c}} is chosen such that \eqn{P(\tau<=\theta)>=0.95}.
}
\references{
Nadja Klein and Thomas Kneib (2015). Scale-Dependent Priors for Variance Parameters in Structured Additive Distributional Regression. 
\emph{Working Paper}.
}
\seealso{
\code{\link{rapprox_unif}},\code{\link{papprox_unif}}
}
\author{
Nadja Klein
}
