% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grim-map.R
\name{grim_map}
\alias{grim_map}
\title{GRIM-test many cases at once}
\usage{
grim_map(
  data,
  items = 1,
  merge_items = TRUE,
  percent = FALSE,
  x = NULL,
  n = NULL,
  show_rec = FALSE,
  show_prob = FALSE,
  rounding = "up_or_down",
  threshold = 5,
  symmetric = FALSE,
  tolerance = .Machine$double.eps^0.5,
  testables_only = FALSE,
  extra = Inf
)
}
\arguments{
\item{data}{Data frame with columns \code{x}, \code{n}, and optionally \code{items} (see
documentation for \code{grim()}. By default, any other columns in \code{data} will be
returned alongside GRIM test results (see \code{extra} below).}

\item{items}{Integer. If there is no \code{items} column in \code{data}, this specifies
the number of items composing the \code{x} values. Default is 1, the most common
case.}

\item{merge_items}{Boolean. If \code{TRUE} (the default), there will be no \code{items}
column in the output. Instead, values from an \code{items} column or argument
will be multiplied with values in the \code{n} column. This does not affect
GRIM-testing.}

\item{percent}{Boolean. Set \code{percent} to \code{TRUE} if the \code{x} values are
percentages. This will convert them to decimal numbers and adjust the
decimal count (i.e., increase it by 2). It also affects the \code{ratio} column.
Default is \code{FALSE}.}

\item{x, n}{Optionally, specify these arguments as column names in \code{data}.}

\item{show_rec}{Boolean. If set to \code{TRUE}, the reconstructed numbers from
GRIM-testing are shown as columns. See section \emph{Reconstructed numbers}
below. Default is \code{FALSE}.}

\item{show_prob}{Boolean. If set to \code{TRUE}, adds a \code{prob} column that
contains the probability of GRIM inconsistency. This is simply the \code{ratio}
column censored to range between 0 and 1. Default is \code{FALSE}.}

\item{rounding, threshold, symmetric, tolerance}{Further parameters of
GRIM-testing; see documentation for \code{grim()}.}

\item{testables_only}{Boolean. If \code{testables_only} is set to \code{TRUE}, only
GRIM-testable cases (i.e., those with a positive GRIM ratio) are included.
Default is \code{FALSE}.}

\item{extra}{String or integer. The other column(s) from \code{data} to be
returned in the output tibble alongside test results, referenced by their
name(s) or number(s). Default is \code{Inf}, which returns all columns. To
return none of them, set \code{extra} to 0.}
}
\value{
A tibble with these columns --
\itemize{
\item \code{x}, \code{n}: the inputs.
\item \code{consistency}: GRIM consistency of \code{x}, \code{n}, and \code{items}.
\item \verb{<extra>}: any columns from \code{data} other than \code{x}, \code{n}, and \code{items}.
\item \code{ratio}: the GRIM ratio; see \code{grim_ratio()}.
}

The tibble has the \code{scr_grim_map} class, which is recognized by the \code{audit()}
generic.
}
\description{
Call \code{grim_map()} to GRIM-test any number of combinations of
mean/proportion, sample size, and number of items. Mapping function for
GRIM-testing.

Set \code{percent} to \code{TRUE} if the \code{x} values are percentages. This will
convert \code{x} values to decimals and adjust the decimal count accordingly.

Display intermediary numbers from GRIM-testing in columns by setting
\code{show_rec} to \code{TRUE}.

For summary statistics, call \code{audit()} on the results.
}
\section{Reconstructed numbers}{
 If \code{show_rec} is set to \code{TRUE}, the output
includes the following additional columns:
\itemize{
\item \code{rec_sum}: the sum total from which the mean or proportion was ostensibly
derived.
\item \code{rec_x_upper}: the upper reconstructed \code{x} value.
\item \code{rec_x_lower}: the lower reconstructed \code{x} value.
\item \code{rec_x_upper_rounded}: the rounded \code{rec_x_upper} value.
\item \code{rec_x_lower_rounded}: the rounded \code{rec_x_lower} value.
}

With the default for \code{rounding}, \code{"up_or_down"}, each of the last two columns
is replaced by two columns that specify the rounding procedures (i.e.,
\code{"_up"} and \code{"_down"}).
}

\section{Summaries with \code{audit()}}{
 There is an S3 method for \code{audit()}, so
you can call \code{audit()} following \code{grim_map()} to get a summary of
\code{grim_map()}'s results. It is a tibble with a single row and these
columns --
\enumerate{
\item \code{incons_cases}: number of GRIM-inconsistent value sets.
\item \code{all_cases}: total number of value sets.
\item \code{incons_rate}: proportion of GRIM-inconsistent value sets.
\item \code{mean_grim_ratio}: average of GRIM ratios.
\item \code{incons_to_ratio}: ratio of \code{incons_rate} to \code{mean_grim_ratio}.
\item \code{testable_cases}: number of GRIM-testable value sets (i.e., those with a
positive ratio).
\item \code{testable_rate}: proportion of GRIM-testable value sets.
}
}

\examples{
# Use `grim_map()` on data like these:
pigs1

# The `consistency` column shows
# whether the values to its left
# are GRIM-consistent:
pigs1 \%>\%
  grim_map()

# Display intermediary numbers from
# GRIM-testing with `show_rec = TRUE`:
pigs1 \%>\%
  grim_map(show_rec = TRUE)

# Get summaries with `audit()`:
pigs1 \%>\%
  grim_map() \%>\%
  audit()
}
\references{
Brown, N. J. L., & Heathers, J. A. J. (2017). The GRIM Test: A
Simple Technique Detects Numerous Anomalies in the Reporting of Results in
Psychology. \emph{Social Psychological and Personality Science}, 8(4), 363–369.
https://journals.sagepub.com/doi/10.1177/1948550616673876
}
