% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_pit}
\alias{plot_pit}
\title{PIT Histogram}
\usage{
plot_pit(pit, num_bins = "auto", breaks = NULL)
}
\arguments{
\item{pit}{either a vector with the PIT values of size n, or a data.frame as
produced by \code{\link[=pit]{pit()}}}

\item{num_bins}{the number of bins in the PIT histogram, default is "auto".
When \code{num_bins == "auto"}, \code{\link[=plot_pit]{plot_pit()}} will either display 10 bins, or it
will display a bin for each available quantile in case you passed in data in
a quantile-based format.
You can control the number of bins by supplying a number. This is fine for
sample-based pit histograms, but may fail for quantile-based formats. In this
case it is preferred to supply explicit breaks points using the \code{breaks}
argument.}

\item{breaks}{numeric vector with the break points for the bins in the
PIT histogram. This is preferred when creating a PIT histogram based on
quantile-based data. Default is \code{NULL} and breaks will be determined by
\code{num_bins}.}
}
\value{
vector with the scoring values
}
\description{
Make a simple histogram of the probability integral transformed values to
visually check whether a uniform distribution seems likely.
}
\examples{
\dontshow{
  data.table::setDTthreads(2) # restricts number of cores used on CRAN
}

# PIT histogram in vector based format
true_values <- rnorm(30, mean = 1:30)
predictions <- replicate(200, rnorm(n = 30, mean = 1:30))
pit <- pit_sample(true_values, predictions)
plot_pit(pit)

# quantile-based pit
pit <- pit(example_quantile,by = "model")
plot_pit(pit, breaks = seq(0.1, 1, 0.1))

# sample-based pit
pit <- pit(example_integer,by = "model")
plot_pit(pit)
}
