% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{show_avail_forecasts}
\alias{show_avail_forecasts}
\title{Visualise Where Forecasts Are Available}
\usage{
show_avail_forecasts(
  data,
  y = "model",
  x = "forecast_date",
  make_x_factor = TRUE,
  summarise_by = NULL,
  collapse_to_one = TRUE,
  by = NULL,
  show_numbers = TRUE,
  facet_formula = NULL,
  facet_wrap_or_grid = "facet_wrap",
  scales = "fixed",
  legend_position = "none"
)
}
\arguments{
\item{data}{data.frame with predictions in the same format required for
\code{\link{eval_forecasts}}}

\item{y}{character vector of length one that denotes the name of the column
to appear on the y-axis of the plot}

\item{x}{character vector of length one that denotes the name of the column
to appear on the x-axis of the plot}

\item{make_x_factor}{logical (default is TRUE). Whether or not to convert
the variable on the x-axis to a factor. This has an effect e.g. if dates
are shown on the x-axis.}

\item{summarise_by}{character vector or \code{NULL} (the default) that
denotes the categories over which the number of forecasts should be summed
up. By default (i.e. \code{summarise_by = NULL}) this will be all the
columns that appear in either x, y, or the facetting formula.}

\item{collapse_to_one}{logical. If \code{TRUE}) (the default), everything
not included in \code{by} will be counted only once. This is useful, for
example, if you don't want to count every single sample or quantile, but
instead treat one set of samples or quantiles as one forecast.}

\item{by}{character vector or \code{NULL} (the default) that denotes the
unit of an individual forecast. This argument behaves similarly to the
\code{by} argument in \code{link{eval_forecasts}}. By default, all columns
are used that are not part of any internally protected columns like "sample"
or "prediction" or similar. The \code{by} argument is only necessary if
\code{collapse_to_one = TRUE} to indicate which rows not to collapse to one.}

\item{show_numbers}{logical (default is \code{TRUE}) that indicates whether
or not to show the actual count numbers on the plot}

\item{facet_formula}{formula for facetting in ggplot. If this is \code{NULL}
(the default), no facetting will take place}

\item{facet_wrap_or_grid}{character. Use ggplot2's \code{facet_wrap} or
\code{facet_grid}? Anything other than "facet_wrap" will be interpreted as
\code{facet_grid}. This only takes effect if \code{facet_formula} is not
\code{NULL}}

\item{scales}{character. The scales argument gets passed down to ggplot.
Only necessary
if you make use of facetting. Default is "fixed"}

\item{legend_position}{character that indicates where to put the legend.
The argument gets passed to ggplot2. By default ("none"), no legend is shown.}
}
\value{
ggplot object with a plot of interval coverage
}
\description{
Visualise Where Forecasts Are Available
}
\examples{
example1 <- scoringutils::range_example_data_long
show_avail_forecasts(example1, x = "value_date", facet_formula = ~ value_desc)
}
