% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/errors.R
\name{mape}
\alias{mape}
\title{Calculate mean absolute percent error between actual and forecast.}
\usage{
mape(actual, forecast, na.rm = TRUE, ...)
}
\arguments{
\item{actual}{a numeric vector of actuals.}

\item{forecast}{a numeric vector of forecasts.}

\item{na.rm}{a logical value indicating whether \code{NA} values should be stripped before the computation proceeds.}

\item{...}{additional arguments to be passed to mean()}
}
\value{
a numeric vector of length one: the mean of of absolute percent errors.
}
\description{
\code{mape} takes actual and forecast numeric vectors and returns a
numeric vector where forecast is subtracted from the actual and
then those errors are divided by the actuals, the
absolute value of those percent errors are then taken, and lastly,
the mean of those absolute percent errors are taken.
}
\examples{
# Examples
mape(1:100, 100:1)
}

