% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manifoldtransform.R, R/tape_smd.R, R/tapell.R
\name{tape_smd}
\alias{tape_smd}
\title{Build CppAD Tapes for Score Matching}
\usage{
tape_smd(
  start,
  tran = "identity",
  end = start,
  ll,
  ytape,
  usertheta,
  bdryw = "ones",
  acut = 1,
  thetatape_creator = function(n) {
     seq(length.out = n)
 },
  verbose = FALSE
)
}
\arguments{
\item{start}{The starting manifold. Used for checking that \code{tran} and \code{man} match.}

\item{tran}{The name of a transformation. Available transformations are
\itemize{
\item ``sqrt''
\item ``alr''
\item ``clr''
\item ``none'' or `identity'
}}

\item{end}{The name of the manifold that \code{tran} maps \code{start} to. Available manifolds are:
\itemize{
\item ``sph'' unit sphere
\item ``Hn111'' hyperplane normal to the vector \eqn{1, 1, 1, 1, ...}
\item ``sim'' simplex
\item ``Euc'' Euclidean space
}}

\item{ll}{An unnormalised log-density with respect to the metric of the starting manifold. \code{ll} must be either an \code{\link{Rcpp_ADFun}} object created by \code{\link[=tape_uld]{tape_uld()}} for a custom unnormalised log-density function or the name of an inbuilt function.}

\item{ytape}{An example measurement value to use for creating the tapes. In the natural (i.e. \code{start}) manifold of the density function.
Please ensure that \code{ytape} is the interior of the manifold and non-zero.}

\item{usertheta}{A vector of parameter elements for the likelihood function. \code{NA} elements will become \emph{dynamic parameters}. Other elements will be fixed at the provided value. The length of \code{usertheta} must be the correct length for the log-density - \strong{no checking is conducted}.}

\item{bdryw}{The name of the boundary weight function. "ones" for manifolds without boundary. For the simplex and positive orthant of the sphere, "prodsq" and "minsq" are possible - see \code{\link[=ppi]{ppi()}} for more information on these.}

\item{acut}{A parameter passed to the boundary weight function \code{bdryw}. Ignored for \code{bdryw = "ones"}.}

\item{thetatape_creator}{A function that accepts an integer \code{n}, and returns a vector of \code{n} length. The function is used to fill in the \code{NA} elements of \code{usertheta} when building the tapes. Please ensure that the values filled by \code{thetatape_creator} lead to plausible parameter vectors for the chosen log-density.}

\item{verbose}{If \code{TRUE} more details are printed when taping. These details are for debugging and will likely be comprehensible only to users familiar with the source code of this package.}
}
\value{
A list of:
\itemize{
\item an \code{\link{Rcpp_ADFun}} object containing a tape of the unnormalised log-density using the metric of the "\code{end}" manifold (that is the independent variable is on the \code{end} manifold).
\item an \code{\link{Rcpp_ADFun}} object containing a tape of the score matching discrepancy function with the non-fixed parameters of the model as the independent variable, and the measurements on the \code{end} manifold as the dynamic parameter.
\item some information about the tapes
}
}
\description{
For a parametric model family, the function \code{tape_smd()} generates \code{CppAD} tapes for the unnormalised log-density of the model family and of the score matching discrepancy function \eqn{A(z) + B(z) + C(z)} (defined in \code{\link{scorematchingtheory}}).
Three steps are performed by \code{tape_smd()}: first an object that specifies the manifold and any transformation to another manifold is created; then a tape of the unnormalised log-density is created; finally a tape of \eqn{A(z) + B(z) + C(z)} is created.
}
\details{
Only some combinations of \code{start}, \code{tran} and \code{end} are available because \code{tran} must map between \code{start} and \code{end}.
These combinations of \code{start}-\code{tran}-\code{end} are currently available:
\itemize{
\item sim-sqrt-sph
\item sim-identity-sim
\item sim-alr-Euc
\item sim-clr-Hn111
\item sph-identity-sph
\item Euc-identity-Euc
}

To build a tape for the score matching discrepancy function, the \code{scorematchingad} first tapes the map from a point \eqn{z} on the \code{end} manifold to the value of the unnormalised log-density, where the independent variable is the \eqn{z}, the dynamic parameter is a vector of the parameters to estimate, and the remaining model parameters are fixed and not estimated.
This tape is then used to generate a tape for the score matching discrepancy function where the parameters to estimate are the independent variable.

The transforms of the manifold must be implemented in \verb{C++} and selected by name.

Currently available unnormalised log-density functions are:
\itemize{
\item dirichlet
\item ppi
\item vMF
\item Bingham
\item FB
}
}
\section{Warning}{
 There is no checking of the inputs \code{ytape} and \code{usertheta}.
}

\examples{
p <- 3
u <- rep(1/sqrt(p), p)
ltheta <- p #length of vMF parameter vector
intheta <- rep(NA, length.out = ltheta)
tapes <- tape_smd("sph", "identity", "sph", "vMF",
              ytape = u,
              usertheta = intheta,
              "ones", verbose = FALSE
              )
evaltape(tapes$lltape, u, runif(n = ltheta))
evaltape(tapes$smdtape, runif(n = ltheta), u)

u <- rep(1/3, 3)
tapes <- tape_smd("sim", "sqrt", "sph", "ppi",
              ytape = u,
              usertheta = ppi_paramvec(p = 3),
              bdryw = "minsq", acut = 0.01,
              verbose = FALSE
              )
evaltape(tapes$lltape, u, rppi_egmodel(1)$theta)
evaltape(tapes$smdtape, rppi_egmodel(1)$theta, u)
}
\references{
\insertAllCited{}
}
\seealso{
Other tape builders: 
\code{\link{tape_Hessian}()},
\code{\link{tape_Jacobian}()},
\code{\link{tape_gradoffset}()},
\code{\link{tape_logJacdet}()},
\code{\link{tape_swap}()},
\code{\link{tape_uld}()}

Other generic score matching tools: 
\code{\link{Windham}()},
\code{\link{cppad_closed}()},
\code{\link{cppad_search}()}
}
\concept{generic score matching tools}
\concept{tape builders}
