% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{gradient_boosting_parameters}
\alias{gradient_boosting_parameters}
\title{Hyperparameter optimisation or parameter tuning for Gradient Boosting Regression Modelling by grid search}
\usage{
gradient_boosting_parameters(base, target, ntree, depth, shrinkage, min_obs,
  bag_fraction, error = "rmse", cv = 1)
}
\arguments{
\item{base}{input dataframe}

\item{target}{column / field name for the target variable to be passed as string (must be 0/1 type)}

\item{ntree}{number of trees to be fitted}

\item{depth}{maximum depth of variable interactions}

\item{shrinkage}{learning rate}

\item{min_obs}{minimum size of terminal nodes}

\item{bag_fraction}{fraction of the training set observations randomly selected for next tree}

\item{error}{(optional) error measure as objective function to be minimised, to be chosen among "mae", "mse" and "rmse" (default value is "rmse")}

\item{cv}{(optional) k vakue for k-fold cross validation to be performed (default value is 1 ie. without cross validation)}
}
\value{
An object of class "gradient_boosting_parameters" is a list containing the following components:

\item{error_tab_detailed}{error summary for each cross validation sample of the parameter combinations iterated during grid search as a dataframe}

\item{error_tab_summary}{error summary for each combination of parameters as a dataframe}

\item{best_ntree}{ntree parameter of the optimal solution}

\item{best_depth}{depth parameter of the optimal solution}

\item{best_shrinkage}{shrinkage parameter of the optimal solution}

\item{best_min_obs}{cost min_obs of the optimal solution}

\item{best_bag_fraction}{bag_fraction parameter of the optimal solution}

\item{runtime}{runtime of the entire process}
}
\description{
The function runs a grid search with k-fold cross validation to arrive at best parameter decided by some performance measure. The parameters that can be tuned using this function for gradient boosting regression modelling algorithm are - ntree, depth, shrinkage, min_obs and bag_fraction. The objective function to be minimised is the error (mean absolute error / mean squared error / root mean squared error). For the grid search, the possible values of each tuning parameter needs to be passed as an array into the function.
}
\examples{
data <- iris
set.seed(11)
data$Y <- sample(0:1,size=nrow(data),replace=TRUE)
gbm_params_list <- gradient_boosting_parameters(base = data,target = "Y",ntree = 2,depth = 2,
                   shrinkage = 0.1,min_obs = 0.1,bag_fraction = 0.7)
gbm_params_list$error_tab_detailed
gbm_params_list$error_tab_summary
gbm_params_list$best_ntree
gbm_params_list$best_depth
gbm_params_list$best_shrinkage
gbm_params_list$best_min_obs
gbm_params_list$best_bag_fraction
gbm_params_list$runtime
}
\author{
Arya Poddar <aryapoddar290990@gmail.com>
}
