% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scorecard.R
\name{scorecard2}
\alias{scorecard2}
\title{Creating a Scorecard}
\usage{
scorecard2(bins, dt, y, x = NULL, points0 = 600, odds0 = 1/19,
  pdo = 50, basepoints_eq0 = FALSE, digits = 0, return_prob = FALSE,
  posprob_pop = NULL, posprob_sample = NULL, positive = "bad|1", ...)
}
\arguments{
\item{bins}{Binning information generated from \code{woebin} function.}

\item{dt}{A data frame with both x (predictor/feature) and y (response/label) variables.}

\item{y}{Name of y variable.}

\item{x}{Name of x variables. If it is NULL, then all variables in bins are used. Defaults to NULL.}

\item{points0}{Target points, default 600.}

\item{odds0}{Target odds, default 1/19. Odds = p/(1-p).}

\item{pdo}{Points to Double the Odds, default 50.}

\item{basepoints_eq0}{Logical, defaults to FALSE. If it is TRUE, the basepoints will equally distribute to each variable.}

\item{digits}{The number of digits after the decimal point for points calculation. Default 0.}

\item{return_prob}{Logical, defaults to FALSE. If it is TRUE, the predict probability will also return.}

\item{posprob_pop}{Positive probability of population. Accepted range: 0-1,  default to NULL. If it is not NULL, the model will adjust for oversampling.}

\item{posprob_sample}{Positive probability of sample. Accepted range: 0-1,  default to the positive probability of the input dt.}

\item{positive}{Value of positive class, default "bad|1".}

\item{...}{Additional parameters.}
}
\value{
A list of scorecard data frames
}
\description{
\code{scorecard2} creates a scorecard based on the results from \code{woebin}. It has the same function of \code{scorecard}, but without model object input and provided adjustment for oversampling.
}
\examples{
\donttest{
# load germancredit data
data("germancredit")
# filter variable via missing rate, iv, identical value rate
dtvf = var_filter(germancredit, "creditability")
# split into train and test
dtlst = split_df(dtvf, y = 'creditability')
# binning
bins = woebin(dtlst$train, "creditability")

# train only
## create scorecard
card1 = scorecard2(bins=bins, dt=dtlst$train, y='creditability')
## scorecard and predicted probability
cardprob1 = scorecard2(bins=bins, dt=dtlst$train, y='creditability', return_prob = TRUE)

# both train and test
## create scorecard
card2 = scorecard2(bins=bins, dt=dtlst, y='creditability')
## scorecard and predicted probability
cardprob2 = scorecard2(bins=bins, dt=dtlst, y='creditability', return_prob = TRUE)

}
}
\seealso{
\code{\link{scorecard}} \code{\link{scorecard_ply}}
}
