% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link-ethoscope-metadata-remote.R,
%   R/link-ethoscope-metadata.R
\name{link_ethoscope_metadata_remote}
\alias{link_ethoscope_metadata_remote}
\alias{link_ethoscope_metadata}
\title{Link ethoscope metadata to the matching result files}
\usage{
link_ethoscope_metadata_remote(x, remote_dir, result_dir,
  index_file = "index.txt", overwrite_local = FALSE, verbose = TRUE)

link_ethoscope_metadata(x, result_dir = NULL, index_file = NULL)
}
\arguments{
\item{x}{object such as a \link{data.frame}, or the name of a file (see detail)}

\item{remote_dir}{the url of the result directory on the data server}

\item{result_dir}{the directory where all data are saved}

\item{index_file}{the name of an index_file, in \code{result_dir} (useful for loading remote data).}

\item{overwrite_local}{whether to download all files.
The default, \code{FALSE}, is to only fetch files if they are newer on the remote.}

\item{verbose}{whether to print progress (a logical)}
}
\value{
a \link[data.table:data.table]{data.table::data.table} with the same rows as x, and extra columns for further data loading
}
\description{
These functions augment metadata so it can be subsequently loaded (with \link{load_ethoscope}).
}
\details{
These function will augment metadata from two different types of inputs (\code{x}):
\enumerate{
\item A \link{data.frame} (recomended)
In this case, the function will try to match requested data with data available on \code{result_dir}.
The provided \link{data.table} has typically one row per requested individual and the columns
(not necessarily in this order):
\itemize{
\item \code{machine_name} -- the name of the machine in which the individual was (e.g. \code{"ETHOSCOPE_001"})
\item \code{date} -- the start date of the experiment formatted as \code{"YYYY-MM-DD"}
\item \code{region_id} -- the ROI in which the animal was. When \emph{not provided, all regions are queried}.
\item \code{time} -- the start time of the experiment formatted as "HH:MM:SS".
When \emph{not provided}, and multiple experiment for the same machine exist, \emph{only the last one is loaded}.
\item \code{???} -- any number of arbitrary columns* to associate \code{conditions}/\code{treatments}/\code{genotypes}/... to the previous columns.
}
\item The name of a CSV file that contains a table as described in \code{1}.
\item A vector of \code{.db} files to be read.
}
}
\examples{
# Metadata with no region_id -> all regions will be loaded with the same metadata
dir <- paste0(scopr_example_dir(), "/ethoscope_results/")
data(no_region_id_metadata)
metadata <- link_ethoscope_metadata(no_region_id_metadata, dir)
print(metadata)

# Metadata with region_id ->  only stated regions will be loaded with specific metadata
data(region_id_metadata)
metadata <- link_ethoscope_metadata(region_id_metadata, dir)
print(metadata)

\dontrun{
# If your files are stored on a remote server,
# this will download to a local directory only the needed files
REMOTE <- "ftp://a/remote/server/"
LOCAL_DIR <- "/where/I/store/the/data/"
metadata <- link_ethoscope_metadata_remote(region_id_metadata,
                                           REMOTE,
                                           LOCAL_DIR)

}
}
\references{
\itemize{
\item \href{https://rethomics.github.io/metadata.html}{metadata tutorial} -- how to work with metadata
}
}
\seealso{
\itemize{
\item \link{load_ethoscope} -- to load the actual data
\item \link{list_result_files} -- to list available file
}
}
