% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scheduler.R
\name{Scheduler}
\alias{Scheduler}
\title{Class for scheduling web requests.}
\description{
Class for scheduling web requests.

Class for scheduling web requests.
}
\details{
The Scheduler class controls the frequency of access to web sites, through
the definiton of access rules (\code{Rule} class).
It handles GET and POST requests, as well as file downloading.
It can use a cache system to store request results and avoid resending
identical requests.
}
\examples{
# Create a scheduler instance without cache
scheduler <- sched::Scheduler$new(cache_dir = NULL)

# Define a rule with default values
scheduler$setRule('www.ebi.ac.uk')

# Create a request object
u <- 'https://www.ebi.ac.uk/webservices/chebi/2.0/test/getCompleteEntity'
url <- sched::URL$new(url=u, params=c(chebiId=15440))
request <- sched::Request$new(url)

# Send the request and get the content result
content <- scheduler$sendRequest(request)


## ------------------------------------------------
## Method `Scheduler$new`
## ------------------------------------------------

# Create a scheduler instance with a custom default_rule
scheduler <- sched::Scheduler$new(default_rule=sched::Rule$new(10, 1),
                                  cache_dir = NULL)


## ------------------------------------------------
## Method `Scheduler$setRule`
## ------------------------------------------------

# Create a scheduler instance
scheduler <- sched::Scheduler$new(cache_dir = NULL)

# Define a rule with default values
scheduler$setRule('www.ebi.ac.uk')

# Define a rule with custome values
scheduler$setRule('my.other.site', n=10, lap=3)


## ------------------------------------------------
## Method `Scheduler$sendRequest`
## ------------------------------------------------

# Create a scheduler instance
scheduler <- sched::Scheduler$new(cache_dir = NULL)

# Define a scheduling rule of 7 requests every 2 seconds
scheduler$setRule('www.ebi.ac.uk', n=7, lap=2)

# Create a request object
u <- 'https://www.ebi.ac.uk/webservices/chebi/2.0/test/getCompleteEntity'
url <- sched::URL$new(url=u, params=c(chebiId=15440))
request <- sched::Request$new(url)

# Send the request and get the content result
content <- scheduler$sendRequest(request)


## ------------------------------------------------
## Method `Scheduler$downloadFile`
## ------------------------------------------------

# Create a scheduler instance
scheduler <- sched::Scheduler$new(cache_dir = NULL)

# Create a temporary directory
tmp_dir <- tempdir()

# Download a file
u <- sched::URL$new(
    'https://gitlab.com/cnrgh/databases/r-sched/-/raw/main/README.md',
    c(ref_type='heads'))
scheduler$downloadFile(u, file.path(tmp_dir, 'README.md'))

# Remove the temporary directory
unlink(tmp_dir, recursive = TRUE)


## ------------------------------------------------
## Method `Scheduler$getUrlString`
## ------------------------------------------------

# Create a scheduler instance
scheduler <- sched::Scheduler$new(cache_dir = NULL)

# Create a URL string
url.str <- scheduler$getUrlString(
  'https://www.ebi.ac.uk/webservices/chebi/2.0/test/getCompleteEntity',
  params=c(chebiId=15440))


## ------------------------------------------------
## Method `Scheduler$getUrl`
## ------------------------------------------------

# Create a scheduler instance
scheduler <- sched::Scheduler$new(cache_dir = NULL)

# Send request
content <- scheduler$getUrl(
  'https://www.ebi.ac.uk/webservices/chebi/2.0/test/getCompleteEntity',
  params=c(chebiId=15440))


## ------------------------------------------------
## Method `Scheduler$deleteRules`
## ------------------------------------------------

# Create a scheduler instance
scheduler <- sched::Scheduler$new(cache_dir = NULL)

# Define a rule with custome values
scheduler$setRule('my.other.site', n=10, lap=3)

# Delete all defined rules
scheduler$deleteRules()


## ------------------------------------------------
## Method `Scheduler$getNbRules`
## ------------------------------------------------

# Create a scheduler instance
scheduler <- sched::Scheduler$new(cache_dir = NULL)

# Get the number of defined rules
print(scheduler$getNbRules())


## ------------------------------------------------
## Method `Scheduler$setOffline`
## ------------------------------------------------

# Create a scheduler instance
scheduler <- sched::Scheduler$new(cache_dir = NULL)

# Enable offline mode
scheduler$setOffline(TRUE)

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Scheduler-new}{\code{Scheduler$new()}}
\item \href{#method-Scheduler-setRule}{\code{Scheduler$setRule()}}
\item \href{#method-Scheduler-sendRequest}{\code{Scheduler$sendRequest()}}
\item \href{#method-Scheduler-downloadFile}{\code{Scheduler$downloadFile()}}
\item \href{#method-Scheduler-getUrlString}{\code{Scheduler$getUrlString()}}
\item \href{#method-Scheduler-getUrl}{\code{Scheduler$getUrl()}}
\item \href{#method-Scheduler-deleteRules}{\code{Scheduler$deleteRules()}}
\item \href{#method-Scheduler-getNbRules}{\code{Scheduler$getNbRules()}}
\item \href{#method-Scheduler-setOffline}{\code{Scheduler$setOffline()}}
\item \href{#method-Scheduler-clone}{\code{Scheduler$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Scheduler-new"></a>}}
\if{latex}{\out{\hypertarget{method-Scheduler-new}{}}}
\subsection{Method \code{new()}}{
New instance initializer.

There should be only one Scheduler instance in an application. There is
no sense in having two or more instances, since they will ignore each
other and break the access frequency rules when they contact the same
sites.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Scheduler$new(
  default_rule = Rule$new(),
  ssl_verifypeer = TRUE,
  nb_max_tries = 10L,
  cache_dir = tools::R_user_dir("sched", which = "cache"),
  user_agent = NULL,
  dwnld_timeout = 3600
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{default_rule}}{The default_rule to use when none has been defined
for a site.}

\item{\code{ssl_verifypeer}}{If set to TRUE (default), SSL certificate will be
checked, otherwise certificates will be ignored.}

\item{\code{nb_max_tries}}{Maximum number of tries when running a request.}

\item{\code{cache_dir}}{Set the path to the file system cache. Set to NULL to
disable the cache system. The cache system will save downloaded content
and reuse it later for identical requests.}

\item{\code{user_agent}}{The application name and contact address to send to the
contacted web server.}

\item{\code{dwnld_timeout}}{The timeout used by \code{downloadFile()} method, in
seconds.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a scheduler instance with a custom default_rule
scheduler <- sched::Scheduler$new(default_rule=sched::Rule$new(10, 1),
                                  cache_dir = NULL)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Scheduler-setRule"></a>}}
\if{latex}{\out{\hypertarget{method-Scheduler-setRule}{}}}
\subsection{Method \code{setRule()}}{
Defines a rule for a site.

Defines a rule for a site. The site is identified by its hostname. Each
time a request will be made to this host (i.e.: the URL contains the
defined hostname), the scheduling rule will be applied in order to wait
(sleep) if nedeed before sending the request.

If a rule already exists for this hostname, it will be replaced.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Scheduler$setRule(host, n = 3L, lap = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host}}{The hostname of the site.}

\item{\code{n}}{Number of events during a time lap.}

\item{\code{lap}}{Duration of a time lap, in seconds.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a scheduler instance
scheduler <- sched::Scheduler$new(cache_dir = NULL)

# Define a rule with default values
scheduler$setRule('www.ebi.ac.uk')

# Define a rule with custome values
scheduler$setRule('my.other.site', n=10, lap=3)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Scheduler-sendRequest"></a>}}
\if{latex}{\out{\hypertarget{method-Scheduler-sendRequest}{}}}
\subsection{Method \code{sendRequest()}}{
Sends a request, and retrieves content result.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Scheduler$sendRequest(request, cache_read = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{request}}{A \code{sched::Request} instance.}

\item{\code{cache_read}}{If set to TRUE and the cache system is enabled, the
cache system will be searched for the request and the cached result
returned. In any case, if the the cache system is enabled, and the
request sent, the retrieved content will be stored into the cache.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The results returned by the contacted server, as a single string
value.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a scheduler instance
scheduler <- sched::Scheduler$new(cache_dir = NULL)

# Define a scheduling rule of 7 requests every 2 seconds
scheduler$setRule('www.ebi.ac.uk', n=7, lap=2)

# Create a request object
u <- 'https://www.ebi.ac.uk/webservices/chebi/2.0/test/getCompleteEntity'
url <- sched::URL$new(url=u, params=c(chebiId=15440))
request <- sched::Request$new(url)

# Send the request and get the content result
content <- scheduler$sendRequest(request)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Scheduler-downloadFile"></a>}}
\if{latex}{\out{\hypertarget{method-Scheduler-downloadFile}{}}}
\subsection{Method \code{downloadFile()}}{
Downloads the content of a URL and save it into the specified
destination file.

This method works for any URL, even if it has been written with heavy
files in mind.
Since it uses \code{utils::download.file()} which saves the content
directly on disk, the cache system is not used.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Scheduler$downloadFile(url, dest_file, quiet = FALSE, timeout = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{The URL to access, as a sched::URL object.}

\item{\code{dest_file}}{A path to a destination file.}

\item{\code{quiet}}{The quiet parameter for \code{utils::download.file()}.}

\item{\code{timeout}}{The timeout in seconds. Defaults to value provided in
initializer.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a scheduler instance
scheduler <- sched::Scheduler$new(cache_dir = NULL)

# Create a temporary directory
tmp_dir <- tempdir()

# Download a file
u <- sched::URL$new(
    'https://gitlab.com/cnrgh/databases/r-sched/-/raw/main/README.md',
    c(ref_type='heads'))
scheduler$downloadFile(u, file.path(tmp_dir, 'README.md'))

# Remove the temporary directory
unlink(tmp_dir, recursive = TRUE)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Scheduler-getUrlString"></a>}}
\if{latex}{\out{\hypertarget{method-Scheduler-getUrlString}{}}}
\subsection{Method \code{getUrlString()}}{
Builds a URL string, using a base URL and parameters to be passed.

The provided base URL and parameters are combined into a full URL string.

DEPRECATED. Use the \code{sched::URL} class and its method
\code{toString()} instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Scheduler$getUrlString(url, params = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{A URL string.}

\item{\code{params}}{A list of URL parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The full URL string as a single character value.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a scheduler instance
scheduler <- sched::Scheduler$new(cache_dir = NULL)

# Create a URL string
url.str <- scheduler$getUrlString(
  'https://www.ebi.ac.uk/webservices/chebi/2.0/test/getCompleteEntity',
  params=c(chebiId=15440))

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Scheduler-getUrl"></a>}}
\if{latex}{\out{\hypertarget{method-Scheduler-getUrl}{}}}
\subsection{Method \code{getUrl()}}{
Sends a request and get the result.

DEPRECATED. Use method \code{sendRequest()} instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Scheduler$getUrl(
  url,
  params = list(),
  method = c("get", "post"),
  header = NULL,
  body = NULL,
  encoding = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{A URL string.}

\item{\code{params}}{A list of URL parameters.}

\item{\code{method}}{The method to use. Either 'get' or 'post'.}

\item{\code{header}}{The header to send.}

\item{\code{body}}{The body to send.}

\item{\code{encoding}}{The encoding to use.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The results of the request.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a scheduler instance
scheduler <- sched::Scheduler$new(cache_dir = NULL)

# Send request
content <- scheduler$getUrl(
  'https://www.ebi.ac.uk/webservices/chebi/2.0/test/getCompleteEntity',
  params=c(chebiId=15440))

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Scheduler-deleteRules"></a>}}
\if{latex}{\out{\hypertarget{method-Scheduler-deleteRules}{}}}
\subsection{Method \code{deleteRules()}}{
Removes all defined rules, including the ones automatically defined using
default_rule.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Scheduler$deleteRules()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a scheduler instance
scheduler <- sched::Scheduler$new(cache_dir = NULL)

# Define a rule with custome values
scheduler$setRule('my.other.site', n=10, lap=3)

# Delete all defined rules
scheduler$deleteRules()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Scheduler-getNbRules"></a>}}
\if{latex}{\out{\hypertarget{method-Scheduler-getNbRules}{}}}
\subsection{Method \code{getNbRules()}}{
Gets the number of defined rules, including the ones automatically
defined using default_rule.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Scheduler$getNbRules()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The number of rules defined.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a scheduler instance
scheduler <- sched::Scheduler$new(cache_dir = NULL)

# Get the number of defined rules
print(scheduler$getNbRules())

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Scheduler-setOffline"></a>}}
\if{latex}{\out{\hypertarget{method-Scheduler-setOffline}{}}}
\subsection{Method \code{setOffline()}}{
Enables or disables offline mode.

If the offline mode is enabled, an error will be raised when the class
attemps to send a request.
This mode is mainly useful when debugging the usage of the cache system.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Scheduler$setOffline(offline)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{offline}}{Set to TRUE to enable offline mode, and FALSE otherwise.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a scheduler instance
scheduler <- sched::Scheduler$new(cache_dir = NULL)

# Enable offline mode
scheduler$setOffline(TRUE)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Scheduler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Scheduler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Scheduler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
