% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastq.R
\name{SplitSRA}
\alias{SplitSRA}
\title{Split SRA to fastq Files and Format to 10x Standard Style.}
\usage{
SplitSRA(
  sra.folder = NULL,
  sra.path = NULL,
  fastq.type = c("10x", "other"),
  split.cmd.path = NULL,
  sratools.path = NULL,
  split.cmd.paras = NULL,
  split.cmd.threads = NULL,
  format.10x = TRUE,
  remove.raw = FALSE
)
}
\arguments{
\item{sra.folder}{Folder contains all sras, obtained from \code{DownloadSRA}. Default: NULL.}

\item{sra.path}{Paths of sras. \code{sra.folder} and \code{sra.path} cannot be both NULL. Default: NULL.}

\item{fastq.type}{The source of fastq files, choose from 10x (use \code{--split-files} to split sra) or
other (use \code{--split-3} to split sra). Default: 10x.}

\item{split.cmd.path}{The full command path used to split, can be path to parallel-fastq-dump,
fasterq-dump and fastq-dump. Default: NULL (conduct automatic detection).}

\item{sratools.path}{Path to sratoolkit bin. When \code{split.cmd.path} is path to parallel-fastq-dump,
it requires sratoolkit. Default: NULL (conduct automatic detection).}

\item{split.cmd.paras}{Parameters for \code{split.cmd.path}. Default: NULL.}

\item{split.cmd.threads}{Threads, used when \code{split.cmd.path} is path to parallel-fastq-dump or fasterq-dump.
Default: NULL (1).}

\item{format.10x}{Logical value, whether to format split fastqs to 10x standard format. Default: TRUE.}

\item{remove.raw}{Logical value, whether to remove old split fastqs (unformatted), used when \code{format.10x} is TRUE. Default: FALSE.}
}
\value{
NULL or paths of failed sras.
}
\description{
Split SRA to fastq Files and Format to 10x Standard Style.
}
\examples{
\dontrun{
# need users to provide the prefetch.path, sra.folder, split.cmd.path, sratools.path and out.folder
GSE186003.runs <- ExtractRun(acce = "GSE186003", platform = "GPL24247")
GSE186003.down <- DownloadSRA(
  gsm.df = GSE186003.runs, prefetch.path = "/path/to/prefetch",
  out.folder = "/path/to/output"
)
GSE186003.split <- SplitSRA(
  sra.folder = "/path/to/output",
  split.cmd.path = "/path/to/parallel-fastq-dump",
  sratools.path = "/path/to/sra/bin", fastq.type = "10x",
  split.cmd.threads = 4
)
}
}
