% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Zenodo.R
\name{ParseZenodo}
\alias{ParseZenodo}
\title{Download Data with Zenodo DOI.}
\usage{
ParseZenodo(
  doi = NULL,
  file.ext = c("rdata", "rds", "h5ad"),
  doi.df = NULL,
  out.folder = NULL,
  timeout = 1000,
  quiet = FALSE,
  parallel = TRUE
)
}
\arguments{
\item{doi}{A vector of Zenodo DOIs to download. Default: NULL.}

\item{file.ext}{The valid file extension for download. When NULL, use all files. Default: c("rdata", "rds", "h5ad").}

\item{doi.df}{DOI dataframe for download. This is useful when something wrong happens in downloading
(e.g. MD5 verification failure, \code{DownloadZenodo} will return a dataframe contains failure terms.). Default: NULL.
It is required to provide either \code{doi} or \code{doi.df}.}

\item{out.folder}{The output folder. Default: NULL (current working directory).}

\item{timeout}{Maximum request time. Default: 1000.}

\item{quiet}{Logical value, whether to show downloading progress. Default: FALSE (show).}

\item{parallel}{Logical value, whether to download parallelly. Default: TRUE. When "libcurl" is available for \code{download.file},
the parallel is done by default (\code{parallel} can be FALSE).}
}
\value{
When successful, NULL. When MD5 verification failure, a dataframe contains failure terms.
}
\description{
Download Data with Zenodo DOI.
}
\examples{
\dontrun{
# need users to provide the output folder
multi.dois.parse <- ParseZenodo(
  doi = c(
    "1111", "10.5281/zenodo.7243603",
    "10.5281/zenodo.7244441"
  ),
  file.ext = c("rdata", "rds"),
  out.folder = "/path/to/outfoder"
)
}
}
