% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/buildtree.R
\name{buildtree}
\alias{buildtree}
\title{Build a scenario tree with a predefined nodal structure.}
\usage{
buildtree(x, treeStruct, lambda_0 = 10, lambda_f = 0.01, e_0 = 0.5,
  e_f = 0.05, jMax = 40000, plot = TRUE)
}
\arguments{
\item{x}{Matrix of initial scenarios, realizations or ensemble members. Each column stores a scenario, with number of rows equal to number of time steps.}

\item{treeStruct}{Matrix defining the nodal structure of the tree (see example). This is a scenario tree nodal partition matrix.}

\item{lambda_0}{Upper neighbourhood range parameter. Default = 10.}

\item{lambda_f}{Lower neighborhood range paramger. Default = 0.01.}

\item{e_0}{Upper adaptation step parameter. Default = 0.5.}

\item{e_f}{Lower adaptation step parameter. Default = 0.05.}

\item{jMax}{Number of iterations. Default = 40000.}

\item{plot}{logical. If TRUE (the default) the final tree is plotted.}
}
\value{
Returns a list object containing the initial input scenarios, the input scenarios tree structure, the values of the final reduced scenario tree, and the tree branch probabilities at the end nodes.
}
\description{
Uses the neural gas method to build a scenario tree.
}
\examples{
# Generate some 25 random realizations of length 4 and reduce to scenario tree.
scenarios <- matrix(rnorm(100),ncol=25)
treeStruct <- rbind(c(1, 1, 1, 1, 1),
                    c(2, 2, 7, 7, 11),
                    c(3, 5, 8, 8, 12),
                    c(4, 6, 9, 10, 13)
                    )
tree <- buildtree(scenarios, treeStruct, jMax = 1000)
}
\references{
Xu, B., Zhong, P.A., Zambon, R.C., Zhao, Y., Yeh, W. (2015) Scenario tree reduction in stochastic programming with recourse for hydropower operations, Water Resources Research, 51, 6359-6380.

Dupacova, Jitka, Giorgio Consigli, and Stein W. Wallace. "Scenarios for multistage stochastic programs." Annals of operations research 100.1-4 (2000): 25-53.
}

