% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sharpenedKDE.R
\name{isMonotoneR}
\alias{isMonotoneR}
\title{Check for monotonicity of function values in the right tail.}
\usage{
isMonotoneR(f, ix)
}
\arguments{
\item{f}{A vector of function values for increasing abscissa values.}

\item{ix}{An index giving the cutoff for checking monotonicity.}
}
\value{
A logical value indicating if the constraint is satisfied.
}
\description{
Given a vector of n function values and an index ix, determines whether the function
values having indices greater than or equal to ix are non-decreasing or non-increasing.
Returns TRUE if they are, FALSE otherwise.
}
\details{
As in \code{isUnimodal}, the values are first scaled to fill [0, 1] and then rounded to
four decimal places.  This eliminates unwanted detection of tiny differences as modes.

This function is intended to be called from other functions in the scdensity package.
It does not implement any argument checking.
}
\keyword{internal}
