% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{smoothChebyshev}
\alias{smoothChebyshev}
\title{Smooth with Chebyshev Polynomials}
\usage{
smoothChebyshev(
  lap,
  coeffs,
  signal,
  l.max,
  n.cores = 1,
  progress.chunks = 5,
  progress = (progress.chunks > 1)
)
}
\arguments{
\item{lap}{graph laplacian}

\item{coeffs}{numeric vector Chebyshev coefficients for a filter}

\item{signal}{Matrix or vector Signal to smooth}

\item{l.max}{numeric maximal eigenvalue of the graph}

\item{n.cores}{numeric Number of cores for parallel run (default=1)}

\item{progress.chunks}{numeric Number of chunks per core for estimating progress (default=5). Large values are not suggested, as it may bring overhead.}

\item{progress}{boolean Flag on whether progress must be shown (default=TRUE, i.e. 'progress.chunks > 1')}
}
\value{
smoothed signal
}
\description{
Smooth with Chebyshev Polynomials
}
\seealso{
Other graph smoothing: 
\code{\link{computeChebyshevCoeffs}()},
\code{\link{heatFilter}()},
\code{\link{smoothSignalOnGraph}()}
}
\concept{graph smoothing}
\keyword{internal}
