% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_negbin.R
\name{sim_negbin_statistic}
\alias{sim_negbin_statistic}
\title{Simulate a single negative binomial score scan statistic.}
\usage{
sim_negbin_statistic(table, zones, wstat_fun)
}
\arguments{
\item{table}{A \code{data.table} with at least the columns \code{mu} and
\code{theta}. The parameter \eqn{\theta} (theta) is the same as 
\code{size} in \code{\link[stats]{rnbinom}}.}

\item{zones}{A \code{set} of zones, each zone itself being a \code{set}
containing locations. Locations should be encoded as integers.}

\item{wstat_fun}{The function that calculates the statistic for each window.}
}
\value{
A scalar; the scan statistic for the simulated data.
}
\description{
Simulate negative binomial-distributed data according to the supplied 
parameters and calculate the value of the score scan statistic, according to 
the specified model.
}
\keyword{internal}

