% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hplm.R
\name{hplm}
\alias{hplm}
\title{Hierarchical piecewise linear model / piecewise regression}
\usage{
hplm(
  data,
  dvar,
  pvar,
  mvar,
  model = "B&L-B",
  method = "ML",
  control = list(opt = "optim"),
  random.slopes = FALSE,
  lr.test = FALSE,
  ICC = TRUE,
  trend = TRUE,
  level = TRUE,
  slope = TRUE,
  fixed = NULL,
  random = NULL,
  update.fixed = NULL,
  data.l2 = NULL,
  ...
)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about this format.}

\item{dvar}{Character string with the name of the dependent variable. Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to the attributes in the scdf file.}

\item{mvar}{Character string with the name of the measurement time variable. Defaults to the attributes in the scdf file.}

\item{model}{Model used for calculating the slope parameter (see Huitema &
McKean, 2000). Default is \code{model = "B&L-B"}. Possible values are:
\code{"B&L-B"}, \code{"H-M"}, \code{"Mohr#1"}, \code{"Mohr#2"}, \code{"JW"}, \code{"JW2"}, and
\code{"Manly"}.}

\item{method}{Method used to fit your model. Pass \code{"REML"} to maximize
the restricted log-likelihood or \code{"ML"} for maximized log-likelihood.
Default is \code{"ML"}.}

\item{control}{A list of settings for the estimation algorithm, replacing
the default values passed to the function \code{lmeControl} of the
\code{nlme} package.}

\item{random.slopes}{If \code{random.slopes = TRUE} random slope effects of
the level, trend, and treatment parameter are estimated.}

\item{lr.test}{If set TRUE likelihood ratio tests are calculated comparing model with vs. without random slope parameters.}

\item{ICC}{If \code{ICC = TRUE} an intraclass-correlation is estimated.}

\item{trend}{A logical indicating if a trend parameters is included in the model.}

\item{level}{A logical indicating if a level parameters is included in the model.}

\item{slope}{A logical indicating if a slope parameters is included in the model.}

\item{fixed}{Defaults to the fixed part of the standard piecewise regression model. The
parameter phase followed by the phase name (e.g., phaseB) indicates the level effect of the corresponding phase. The parameter 'inter' followed by the phase name (e.g., interB) adresses the slope effect based on the method
provide in the model argument (e.g., "B&L-B"). The formula can be changed
for example to include further L1 or L2 variables into the regression model.}

\item{random}{The random part of the model.}

\item{update.fixed}{An easier way to change the fixed model part (e.g., . ~ . + newvariable).}

\item{data.l2}{A dataframe providing additional variables at Level 2. The
scdf File has to have names for all cases and the Level 2 dataframe has to
have a column named 'cases' with the names of the cases the Level 2
variables belong to.}

\item{...}{Further arguments passed to the lme function.}
}
\value{
\item{model}{List containing infromation about the applied model} 
\item{N}{Number of single-cases.}
\item{formla}{A list containing the fixed and the random formulas of the hplm model.}
\item{hplm}{Object of class lme contaning the multilevel model} 
\item{model.0}{Object of class lme containing the Zero Model.} 
\item{ICC}{List containing intraclass correlation and test parameters.}
\item{model.without}{Object of class gls containing the fixed effect model.}
}
\description{
The \code{hplm} function computes a hierarchical piecewise regression model.
}
\examples{

## Compute hplm model on a MBD over fifty cases (restricted log-likelihood)
hplm(exampleAB_50, method = "REML", random.slopes = FALSE)

## Analyzing with additional L2 variables
hplm(Leidig2018, data.l2 = Leidig2018_l2, 
     update.fixed = .~. + gender + migration + ITRF_TOTAL*phaseB, 
     slope = FALSE, random.slopes = FALSE, lr.test = FALSE)
     
}
\seealso{
Other regression functions: 
\code{\link{corrected_tau}()},
\code{\link{mplm}()},
\code{\link{plm}()}
}
\author{
Juergen Wilbert
}
\concept{regression functions}
