% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCALPEL_stepFunctions.R
\name{scalpelStep2}
\alias{scalpelStep2}
\title{Perform Step 2 of SCALPEL.}
\usage{
scalpelStep2(step1Output, cutoff = 0.18, omega = 0.2, maxSizeToCluster = 3000)
}
\arguments{
\item{step1Output}{An object of class \code{scalpel} or \code{scalpelStep1}, which result from running the
\code{\link{scalpel}} or \code{\link{scalpelStep1}} functions, respectively.}

\item{cutoff}{A value in [0,1] indicating where to cut the dendrogram that results from hierarchical clustering
of the preliminary dictionary elements. The default value is 0.18.}

\item{omega}{A value in [0,1] indicating how to weight spatial vs. temporal information in the dissimilarity metric
used for clustering. If \code{omega=1}, only spatial information is used. The default value is 0.2.}

\item{maxSizeToCluster}{Optional advanced user argument: The maximum number of preliminary dictionary elements to cluster at once. We attempt to cluster each
overlapping set of preliminary dictionary elements, but if one of these sets is very large (e.g., >10,000), memory issues may
result. Thus we perform a two-stage clustering in which we first cluster together random sets of size
approximately equaling \code{maxSizeToCluster} and then cluster together the representatives from the first stage.
Finally, we recalculate the representatives using all of the preliminary dictionary elements in the final clusters. The default value is 3000.
If \code{maxSizeToCluster} is set to \code{NULL}, single-stage clustering is done, regardless of the size of the overlapping sets.
Memory issues may result when using this option to force single-stage clustering if the size of
the largest overlapping set of preliminary dictionary elements is very large (e.g., >10,000).}
}
\value{
An object of class \code{scalpelStep2}, which can be summarized using \code{\link{summary}}, used to run SCALPEL Step 3 using \code{\link{scalpelStep3}},
or can be used with the plotting functions \code{\link{plotCluster}} and \code{\link{plotSpatial}}.
\itemize{
\item{\code{A}: }{A matrix containing the dictionary elements, where the ith column of \code{A}
is a vector of 1's and 0's, indicating whether each pixel is contained in the ith dictionary element.}
\item{\code{repComps}: }{A vector where the ith element indicates which preliminary dictionary element is the ith representive
component. That is, \code{A[,i]=step1Output$Azero[,repComps[i]]}.}
\item{\code{clusterID}: }{A vector whose ith element indicates which of the dictionary elements in \code{A} is the
representative for the ith preliminary dictionary element.}
\item{\code{overlapSetID}: }{A vector indicating which preliminary dictionary elements overlap, with the ith element
giving the group index for the ith preliminary dictionary element.}
\item{\code{treeList}: }{A list of length \code{max(overlapSetID)} with the ith element containing an object of class \code{protoclust} corresponding
to prototype clustering for the preliminary dictionary elements with \code{overlapSetID=i}. If two-stage clustering was done for a
particular set, then the element will be \code{NULL}.}
\item{Other elements: }{As specified by the user or returned from a previous step.}
}
}
\description{
This step involves refinement of the spatial component dictionary from Step 1. We eliminate redundancy
in the spatial component dictionary by clustering together preliminary dictionary elements that represent
the same neuron, based on spatial and temporal information.
}
\details{
Several files containing data from this step and a summary of the step are saved in the folder
"outputFolder/Step1_version/Step2_omega_omega_cutoff_cutoff" where \code{version} is a 5-digit unique
 identifier that is automatically generated in Step 1 and \code{omega} and \code{cutoff} are the user-supplied parameters.
}
\examples{
\dontrun{
### many of the functions in this package are interconnected so the
### easiest way to learn to use the package is by working through the vignette,
### which is available at ajpete.com/software

#assumes you have run the example for the "scalpelStep1" function

#run Step 2 of SCALPEL
Step2Out = scalpelStep2(step1Output = Step1Out)
summary(Step2Out)
}
}
\seealso{
The entire SCALPEL pipeline can be implemented using the \code{\link{scalpel}} function. The
other steps in the pipeline can be run using the \code{\link{scalpelStep0}}, \code{\link{scalpelStep1}}, \code{\link{scalpelStep3}} functions.
Results from this step can be summarized using \code{\link{summary}}, loaded at a later time using \code{\link{getScalpelStep2}}, and plotted using
\code{\link{plotCluster}} and \code{\link{plotSpatial}}.
}
