% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/par_est_fns.R
\name{fit_params}
\alias{fit_params}
\title{Functions to estimate parameters of probability distributions by fitting the distributions using optim()}
\usage{
fit_params(x, type, optim_control = list(maxit = 1000))
}
\arguments{
\item{x}{Vector containing the discrete observations}

\item{type}{Keyword for the probability distribution the data is to be fitted
against. Possible values are ("pois", "nb", "pb", "pois2", "nb2",
 "pb2", "zipois", "zinb", "zipb", "zipois2", "zinb2", "zipb2")}

\item{optim_control}{List of options to override presets in
the optim function; Set to list(maxit = 1000) by default.
For more details, please refer to the 'control' parameter in the
standard 'optim' function in package 'stats'.}
}
\description{
Functions to estimate parameters of probability distributions by fitting the distributions using optim()
}
\examples{
x1 <- rnbinom(100, size = 13, mu = 9)
p1 <- fit_params(x1, "nb")
s <- sample(x = c(0,1), size = 100, replace = TRUE, prob = c(0.3,0.7))
x2 <- s*x1 + (1-s)*rnbinom(100, size = 15, mu = 53)
p2 <- fit_params(x2, "nb2")
}
\keyword{estimation}
\keyword{parameter}
