% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tissue_by_celltype_enirchment.R
\name{tissue_by_celltype_enrichment}
\alias{tissue_by_celltype_enrichment}
\title{tissue_by_celltype_enrichment}
\usage{
tissue_by_celltype_enrichment(
  gene_list,
  species,
  name = "CT_Tissue_example",
  p_thresh = 0.05,
  rda_path = "",
  isect_size = 3,
  return_gmt = FALSE
)
}
\arguments{
\item{gene_list}{A character vector of gene symbols with the same designation (e.g. mouse symbol - mouse, human symbol - human) as the gene set database.}

\item{species}{Species of cell-type marker to use ('human' or 'mouse').}

\item{name}{Name of the pdf to be printed.}

\item{p_thresh}{The Fisher's test cut-off for a cell-marker to be enriched.}

\item{rda_path}{Path to a .rda file containing an object called "gmt". Either human or mouse cell-type markers split by experiment. If the correct file isn't present they will be downloaded from https://github.com/wilsonlabgroup/scMappR_Data.}

\item{isect_size}{Number of genes in your list and the cell-type.}

\item{return_gmt}{Return .gmt file -- reccomended if downloading from online as it may have updated (T/F).}
}
\value{
List with the following elements:
\item{enriched}{Data frame of enriched cell-types from tissues.}
\item{gmt}{Cell-markers in enriched cell-types from tissues.}
}
\description{
This function uses a Fisher's-exact-test to rank gene-set enrichment.
}
\details{
Complete a Fisher's exact test of an input list of genes against one of the two curated tissue by cell-type marker datasets from scMappR.
}
\examples{
\donttest{

data(POA_example)
POA_generes <- POA_example$POA_generes
POA_OR_signature <- POA_example$POA_OR_signature
POA_Rank_signature <- POA_example$POA_Rank_signature
Signature <- POA_Rank_signature
rowname <- get_gene_symbol(Signature)
rownames(Signature) <- rowname$rowname
genes <- rownames(Signature)[1:100]

enriched <- tissue_by_celltype_enrichment(gene_list = genes, 
species = "mouse",p_thresh = 0.05, isect_size = 3)

}
 
}
