% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_dgTMatrix_lists.R
\name{process_dgTMatrix_lists}
\alias{process_dgTMatrix_lists}
\title{Count Matrix To Signature Matrix}
\usage{
process_dgTMatrix_lists(
  dgTMatrix_list,
  name,
  species_name,
  naming_preference = -9,
  rda_path = "",
  panglao_set = FALSE,
  haveUMAP = FALSE,
  saveSCObject = FALSE,
  internal = FALSE,
  toSave = FALSE,
  path = NULL,
  use_sctransform = FALSE,
  test_ctname = "wilcox",
  genes_integrate = 2000,
  genes_include = FALSE
)
}
\arguments{
\item{dgTMatrix_list}{A list of matrices in the class of dgTMatrix object -- sparce object -- compatible with Seurat rownames should be of the same species for each.}

\item{name}{The name of the outputted signature matrices, cell-type preferences, and seurat objects if you choose to save them.}

\item{species_name}{Mouse or human symbols, -9 if internal as panglao objects have gene symbol and ensembl strapped together.}

\item{naming_preference}{For cell-type naming, see if cell-types given the inputted tissues are more likely to be named within one of the categories of get_naming_preference_options().}

\item{rda_path}{If saved, directory to where data from scMappR_data is downloaded.}

\item{panglao_set}{If the inputted matrices are from Panglao (i.e. if they're internal).}

\item{haveUMAP}{Save the UMAPs -- only use if the package is downloaded with pip.}

\item{saveSCObject}{Save the Seurat object as an RData object (T/F).}

\item{internal}{Was this used as part of the internal processing of Panglao datasets (T/F).}

\item{toSave}{Allow scMappR to write files in the current directory (T/F)}

\item{path}{If toSave == TRUE, path to the directory where files will be saved.}

\item{use_sctransform}{If you should use sctransform or the Normalize/VariableFeatures/ScaleData pipeline (T/F).}

\item{test_ctname}{statistical test for calling CT markers -- must be in Seurat}

\item{genes_integrate}{The number of genes to include in the integration anchors feature when combining datasets -- passed into process_from_count}

\item{genes_include}{TRUE or FALSE -- include 2000 genes in signature matrix or all matrix.}
}
\value{
List with the following elements:
\item{wilcoxon_rank_mat_t}{A dataframe containing the signature matrix of ranks (-log10(Padj) * sign(fold-change)).}
\item{wilcoxon_rank_mat_or}{A dataframe containing the signature matrix of odds-ratios.}
\item{generes}{All cell-type markers for each cell-type with p-value and fold changes.}
}
\description{
This function takes a list of count matrices, processes them, calls cell-types, and generates signature matrices.
}
\details{
This function is a one line wrapper to process count matrices into a signature matrix.
It combines process_from_count, two methods of identifying cell-type identities (GSVA and Fisher's test).
Then, it takes the output of cell-type markers and converts it into a signature matrix of p-value ranks and odds ratios.
Along the way, it saves the Seurat object (if chosen with saveSCObject), cell-type identites from GSVA (its own obect), and the signature matrices.
Cell-type marker outputs are also saved in the generes.RData list. Names of the generes objects and the signature matrices are kept.
}
\examples{
\donttest{
data(sm)
toProcess <- list(example = sm)
tst1 <- process_dgTMatrix_lists(toProcess, name = "testPropcess", species_name = -9,
 naming_preference = "eye", rda_path = "")

}
}
