% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeconRNAseq_CRAN.R
\name{DeconRNAseq_CRAN}
\alias{DeconRNAseq_CRAN}
\title{DeconRNASeq CRAN compatible}
\usage{
DeconRNAseq_CRAN(
  datasets,
  signatures,
  proportions = NULL,
  checksig = FALSE,
  known.prop = FALSE,
  use.scale = TRUE,
  fig = FALSE
)
}
\arguments{
\item{datasets}{Normalized RNA-seq dataset}

\item{signatures}{Signature matrix of odds ratios}

\item{proportions}{If cell-type proportion is already inputted - always NULL for scMappR}

\item{checksig}{Check to see if plotting is significant - always false for scMappR}

\item{known.prop}{If proportions were known - always false for scMappR}

\item{use.scale}{Scale and center value - always TRUE for scMappR}

\item{fig}{Make figures - always FALSE for scMappR}
}
\value{
\code{DeconRNAseq_CRAN} Estimated cell-type proportions with DeconRNAseq. \cr
}
\description{
This function runs DeconRNAseq with default parameters such that it is compatible with CRAN and scMappR
}
\details{
This is the exact same function as the primary function in the Bioconductor package, DeconRNAseq (PMID: 23428642)
except it is now compatible with CRAN packages.
}
\examples{
\donttest{
data(PBMC_example)
bulk_DE_cors <- PBMC_example$bulk_DE_cors
bulk_normalized <- PBMC_example$bulk_normalized
odds_ratio_in <- PBMC_example$odds_ratio_in
out <- DeconRNAseq_CRAN(as.data.frame(bulk_normalized), as.data.frame(odds_ratio_in))
}
                                      
}
