% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{crossSpeciesCellTypeGOCorrRescale}
\alias{crossSpeciesCellTypeGOCorrRescale}
\title{calculate cross-species correlation between cell types represented by scaled GO, re-scale based on shared GOs between species
recommended when species share less common GOs}
\usage{
crossSpeciesCellTypeGOCorrRescale(
  species_1,
  species_2,
  go_seurat_obj_sp1,
  go_seurat_obj_sp2,
  cell_type_col_sp1,
  cell_type_col_sp2,
  norm_log1p_sp1 = TRUE,
  norm_log1p_sp2 = TRUE,
  corr_method = "pearson"
)
}
\arguments{
\item{species_1}{name of species one}

\item{species_2}{name of species two}

\item{go_seurat_obj_sp1}{seurat object with GO profiles from species 1}

\item{go_seurat_obj_sp2}{seurat object with GO profiles from species 2}

\item{cell_type_col_sp1}{column with cell type annotation from species 1}

\item{cell_type_col_sp2}{column with cell type annotation from species 2}

\item{norm_log1p_sp1}{whether or not perform normalization and log1p for counts data in species 1, default TRUE}

\item{norm_log1p_sp2}{whether or not perform normalization and log1p for counts data in species 2, default TRUE}

\item{corr_method}{correlation method, choose among "pearson", "kendall", "spearman", default 'pearson'}
}
\value{
correlation between cell types, scaling using only shared GOs
}
\description{
calculate cross-species correlation between cell types represented by scaled GO, re-scale based on shared GOs between species
recommended when species share less common GOs
}
\examples{
\donttest{
library(scGOclust)
library(httr)
httr::set_config(httr::config(ssl_verifypeer = FALSE))
mmu_tbl = ensemblToGo(species = 'mmusculus')
data(mmu_subset)
dme_tbl = ensemblToGo(species = 'dmelanogaster')
data(dme_subset)
mmu_go_obj = makeGOSeurat(ensembl_to_GO = mmu_tbl,
 seurat_obj = mmu_subset,
 feature_type = "external_gene_name")
dme_go_obj = makeGOSeurat(ensembl_to_GO = dme_tbl,
 seurat_obj = dme_subset,
 feature_type = "external_gene_name")
crossSpeciesCellTypeGOCorrRescale(species_1 = 'mmusculus',
 species_2 = 'dmelanogaster',
 go_seurat_obj_sp1 = mmu_go_obj,
 go_seurat_obj_sp2 = dme_go_obj,
 cell_type_col_sp1 = 'cell_type_annotation',
 cell_type_col_sp2 = 'annotation')
}
}
