% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scDIFtest.R
\name{scDIFtest}
\alias{scDIFtest}
\title{A score-based item-wise DIF test}
\usage{
scDIFtest(
  object,
  DIF_covariate = NULL,
  functional = NULL,
  item_selection = NULL,
  decorrelate = TRUE,
  ...
)
}
\arguments{
\item{object}{a fitted model object of class \code{\link[mirt]{SingleGroupClass-class}}
or \code{\link[mirt]{MultipleGroupClass-class}}, resulting from an IRT analysis
using the \code{mirt}-package.}

\item{DIF_covariate}{a vector with the person covariate to use for the DIF-test.
The covariate can be categorical, ordered categorical or numerical.}

\item{functional}{a character specifying the functional (or test statistic) to
be used. See details for more information.}

\item{item_selection}{either \code{NULL} or an integer vector selecting the item
numbers. When \code{items = NULL} (the default), the DIF test is done for all
items.}

\item{decorrelate}{a logical. Should the process be decorrelated?}

\item{...}{other arguments passed to the \code{sctest} method.}
}
\value{
An object of class \code{scDIFtest} \link{scDIFtest-Methods}, which is a list with three elements
   \describe{
     \item{tests}{A named list with a number of elements equal to the number of
                  the items for which DIF should be detected. Each element
                  contains information both about the test \code{single_test}
                  as well as the \code{\link[strucchange]{efpFunctional}}}
     \item{info}{A named list with two elements. \code{test_info} contains
                 information such as used test statistic and the used covariate.
                 \code{item_info} contains information about the items such as
                 the item types as well as the column numbers of the score matrix
                 that correspond to the estimated parameters of the items.}
     \item{gefp}{The Generalized Empirical M-Fluctuation Process (\code{gefp})
                 based on the complete model with all the estimated parameters
                 (see \code{\link[strucchange]{gefp}}).}
   }
}
\description{
A function that executes item-wise score-based DIF tests. After fitting an
IRT model with \code{\link[mirt]{mirt}}, the fitted object can be used to
assess and test measurement invariance, using
\code{\link[strucchange]{sctest}}. However, by default, all parameters of
the fitted model are tested simultaneously. This function applies the
\code{\link[strucchange]{sctest}} to test for item-wise DIF, in an efficient
way.
}
\details{
For more information about the functional see the documentation of
\code{\link[strucchange]{sctest.default}} or
\code{\link[strucchange]{sctest.formula}}. When \code{functional = NULL}
(which is the default), the functional is chosen based on the class of
\code{DIF_covariate}. In this case, for \code{integer} and \code{numeric} vectors
the Double Maximum (\code{"DM"}) is used; for \code{ordered} vectors the
Maximum Lagrange Multiplier Test for Ordered Groups (\code{"maxLMo"}) is
used; and for \code{factor}, \code{character}, and \code{logical} vectors the
Lagrange Multiplier Test for Unordered Groups is used.
}
\examples{
\donttest{
library(mirt)
library(scDIFtest)
### data and model
dat <- expand.table(LSAT7)
nObs <- dim(dat)[1]
mod <- mirt(dat, 1, itemtype = "2PL", constr = list(c(2, 1)))

### DIF along a metric variable
###  the default test statistic is the Double Maximum (dm)
metric <- rnorm(nObs) 
DIF_metric <- scDIFtest(mod, DIF_covariate = metric)
DIF_metric
plot(DIF_metric, 1)

### DIF along an ordered categorical variable
###  the default test statistic is the Maximum Lagrange Multiplier Test 
###  for Ordered Groups (maxlmo)
ordered <- ordered(sample(1:5, size = nObs, replace = TRUE))
DIF_ordered <- scDIFtest(mod, DIF_covariate = ordered)
summary(DIF_ordered)

### Note that the Generalized Empirical M-Fluctuation Process (gefp) based on all
###  the estimated parameters in the model is an element of the resulting
###  scDIFtest object. This means that one can use this gefp to test the
###  general hypothesis of measurement invariance with respect to the
###  chosen covariate.
strucchange::sctest(DIF$gefp)
}


}
