% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Seurat_Iterative_Plotting.R
\name{Iterate_Plot_Density_Joint}
\alias{Iterate_Plot_Density_Joint}
\title{Iterative Plotting of Gene Lists using Custom Joint Density Plots}
\usage{
Iterate_Plot_Density_Joint(
  seurat_object,
  gene_list,
  viridis_palette = "magma",
  custom_palette = NULL,
  pt.size = 1,
  file_path = NULL,
  file_name = NULL,
  file_type = NULL,
  single_pdf = FALSE,
  dpi = 600,
  reduction = NULL,
  combine = TRUE,
  joint = NULL,
  ...
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{gene_list}{a list of vectors of genes to plot jointly.  Each entry in the list will be plotted
for the joint density.  All entries in list must be greater than 2 features.  If a named list is provided
then the names for each list entry will be incorporated into plot title if \code{single_pdf = TRUE} or
into file name if \code{FALSE}.}

\item{viridis_palette}{color scheme to use.}

\item{custom_palette}{color for non-expressed cells.}

\item{pt.size}{Adjust point size for plotting.}

\item{file_path}{directory file path and/or file name prefix.  Defaults to current wd.}

\item{file_name}{name suffix and file extension.}

\item{file_type}{File type to save output as.  Must be one of following: ".pdf", ".png", ".tiff", ".jpeg", or ".svg".}

\item{single_pdf}{saves all plots to single PDF file (default = FALSE).  `file_type`` must be .pdf.}

\item{dpi}{dpi for image saving.}

\item{reduction}{Dimensionality Reduction to use (if NULL then defaults to Object default)}

\item{combine}{Create a single plot? If FALSE, a list with ggplot objects is returned.}

\item{joint}{NULL.  This function only supports \code{joint = FALSE}.  Leave as NULL to generate plots.  To iterate joint plots see function: \code{Iterate_Plot_Density_Joint}.}

\item{...}{Extra parameters passed to \code{\link[Nebulosa]{plot_density}}.}
}
\value{
Saved plots
}
\description{
Create and save plots for gene list with single command.  Requires Nebulosa package from Bioconductor.
}
\examples{
\dontrun{
Iterate_Plot_Density_Joint(seurat_object = object, gene_list = DEG_list, viridis_palette = "magma",
file_path = "plots/", file_name = "joint_plots", file_type = ".jpg", dpi = 600)
}

}
\concept{iterative_plotting}
