% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC_Plotting_Seq_10X.R
\name{Seq_QC_Plot_Number_Cells}
\alias{Seq_QC_Plot_Number_Cells}
\title{QC Plots Sequencing metrics}
\usage{
Seq_QC_Plot_Number_Cells(
  metrics_dataframe,
  plot_by = "sample_id",
  colors_use = NULL,
  x_lab_rotate = FALSE,
  significance = FALSE,
  ...
)
}
\arguments{
\item{metrics_dataframe}{data.frame  contain Cell Ranger QC Metrics (see \code{\link{Read_Metrics_10X}}).}

\item{plot_by}{Grouping factor for the plot.  Default is to plot as single group with single point per sample.}

\item{colors_use}{colors to use for plot if plotting by group.  Defaults to RColorBrewer Dark2 palette if
less than 8 groups and \code{DiscretePalette_scCustomize(palette = "polychrome")} if more than 8.}

\item{x_lab_rotate}{logical.  Whether to rotate the axes labels on the x-axis.  Default is FALSE.}

\item{significance}{logical.  Whether to calculate and plot p-value comparisons when plotting by
grouping factor.  Default is FALSE.}

\item{...}{Other variables to pass to \code{ggpubr::stat_compare_means} when doing significance testing.}
}
\value{
A ggplot object
}
\description{
Plot the number of cells per sample
}
\examples{
\dontrun{
Seq_QC_Plot_Number_Cells(metrics_dataframe = metrics)
}

}
\concept{seq_qc_plotting_basic}
