% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{Merge_Sparse_Data_All}
\alias{Merge_Sparse_Data_All}
\title{Merge a list of Sparse Matrices}
\usage{
Merge_Sparse_Data_All(
  matrix_list,
  add_cell_ids = NULL,
  prefix = TRUE,
  cell_id_delimiter = "_"
)
}
\arguments{
\item{matrix_list}{list of matrices to merge.}

\item{add_cell_ids}{a vector of sample ids to add as prefix to cell barcode during merge.}

\item{prefix}{logical.  Whether \code{add_cell_ids} should be added as prefix to current cell barcodes/names
or as suffix to current cell barcodes/names.  Default is TRUE, add as prefix.}

\item{cell_id_delimiter}{The delimiter to use when adding cell id prefix/suffix.  Default is "_".}
}
\value{
A sparse Matrix
}
\description{
Enables easy merge of a list of sparse matrices
}
\examples{
\dontrun{
data_list <- Read10X_GEO(...)
merged <- Merge_Sparse_Data_All(matrix_list = data_list, add_cell_ids = names(data_list),
prefix = TRUE, cell_id_delimiter = "_")
}

}
\references{
Original function is part of LIGER package as non-exported function
\url{https://github.com/welch-lab/liger/blob/master/R/utilities.R} (License: GPL-3).
Function was modified for use in scCustomize (add progress bar, prefix vs. suffix, and delimiter options).
}
\concept{helper_util}
