% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_rename_files.R
\name{item_rename_files}
\alias{item_rename_files}
\title{Rename item attached files}
\usage{
item_rename_files(sb_id, names, new_names, ...,
  session = current_session())
}
\arguments{
\item{sb_id}{An \code{\link{sbitem}} object or a character ScienceBase ID corresponding to the item}

\item{names}{List of names of files to rename}

\item{new_names}{List of new file names to use}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}, or \code{\link[httr]{DELETE}}}

\item{session}{Session object from \code{\link{authenticate_sb}}. Defaults to anonymous or 
last authenticated session}
}
\description{
Renames files attached to an SB item.
}
\examples{
\dontrun{

names = c('file1.txt', 'file2.txt')
new_names = c('newname1.txt', 'newname2.txt')

item_rename_files('sbid', names, new_names)

}

}
